/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.web.deployer.internal.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.osgi.service.importer.support.ImportContextClassLoader;
import org.springframework.osgi.service.importer.support.OsgiServiceProxyFactoryBean;
import org.springframework.osgi.util.BundleDelegatingClassLoader;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.osgi.web.deployer.internal.util.ChainedClassLoader;
import org.springframework.osgi.web.deployer.internal.util.JasperUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public abstract class Utils {
    private static final Log log = LogFactory.getLog((Class)Utils.class);
    private static final String SLASH = "/";

    public static void unpackBundle(Bundle bundle, File targetFolder) {
        Enumeration enm = bundle.findEntries(SLASH, null, true);
        while (enm != null && enm.hasMoreElements()) {
            boolean trace = log.isTraceEnabled();
            URL url = (URL)enm.nextElement();
            String entryPath = url.getPath();
            if (entryPath.startsWith(SLASH)) {
                entryPath = entryPath.substring(1);
            }
            File targetFile = new File(targetFolder, entryPath);
            if (entryPath.endsWith(SLASH)) {
                targetFile.mkdirs();
                continue;
            }
            try {
                File parent = targetFile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                FileOutputStream targetStream = new FileOutputStream(targetFile);
                if (trace) {
                    log.trace((Object)("Copying " + url + " to " + targetFile));
                }
                FileCopyUtils.copy((InputStream)url.openStream(), (OutputStream)targetStream);
            }
            catch (IOException ex) {
                log.error((Object)("Cannot copy resource " + entryPath), (Throwable)ex);
                throw (RuntimeException)new IllegalStateException("IO exception while unpacking bundle " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle)).initCause(ex);
            }
        }
    }

    public static Object createServerServiceProxy(BundleContext bundleContext, Class proxyType, String serviceName) {
        OsgiServiceProxyFactoryBean proxyFB = new OsgiServiceProxyFactoryBean();
        proxyFB.setBundleContext(bundleContext);
        proxyFB.setContextClassLoader(ImportContextClassLoader.UNMANAGED);
        proxyFB.setInterfaces(new Class[]{proxyType});
        proxyFB.setBeanClassLoader(proxyType.getClassLoader());
        proxyFB.setTimeout(5000L);
        if (StringUtils.hasText((String)serviceName)) {
            proxyFB.setServiceBeanName(serviceName);
        }
        proxyFB.afterPropertiesSet();
        return proxyFB.getObject();
    }

    public static ClassLoader chainedWebClassLoaders(Class serverClass) {
        Assert.notNull((Object)serverClass);
        ClassLoader serverLoader = serverClass.getClassLoader();
        ClassLoader jasperLoader = Utils.findClassLoaderFor("org.apache.jasper.servlet.JspServlet", serverLoader);
        if (jasperLoader == null) {
            jasperLoader = Utils.findClassLoaderFor("org.apache.jasper.servlet.JspServlet", Utils.class.getClassLoader());
        }
        if (jasperLoader == null) {
            return serverLoader;
        }
        return new ChainedClassLoader(new ClassLoader[]{serverLoader, jasperLoader});
    }

    private static ClassLoader findClassLoaderFor(String className, ClassLoader classLoader) {
        try {
            Class clazz = ClassUtils.forName((String)className, (ClassLoader)classLoader);
            return clazz.getClassLoader();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static URLClassLoader createWebAppClassLoader(Bundle bundle, Class serverClass) {
        ClassLoader serverClassLoader = Utils.chainedWebClassLoaders(serverClass);
        BundleDelegatingClassLoader classLoader = BundleDelegatingClassLoader.createBundleClassLoaderFor((Bundle)bundle, (ClassLoader)serverClassLoader);
        URLClassLoader urlClassLoader = JasperUtils.createJasperClassLoader(bundle, (ClassLoader)classLoader);
        return urlClassLoader;
    }
}

