/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.util.URIUtil;
import org.ops4j.lang.NullArgumentException;

class WelcomeFilesFilter
implements Filter {
    private static final Log LOG = LogFactory.getLog(WelcomeFilesFilter.class);
    private final String[] m_welcomeFiles;
    private final boolean m_redirect;
    private FilterConfig m_filterConfig;

    WelcomeFilesFilter(String[] welcomeFiles, boolean redirect) {
        NullArgumentException.validateNotNull(welcomeFiles, "Welcome files");
        if (welcomeFiles.length == 0) {
            throw new NullArgumentException("Welcome files is be empty");
        }
        for (String welcomeFile : welcomeFiles) {
            if (welcomeFile == null || welcomeFile.trim().length() == 0) {
                throw new NullArgumentException("Welcome files entry is null or empty");
            }
            if (welcomeFile.startsWith("/")) {
                throw new NullArgumentException("Welcome files entry [" + welcomeFile + "] starts with '/'");
            }
            if (!welcomeFile.endsWith("/")) continue;
            throw new NullArgumentException("Welcome files entry [" + welcomeFile + "] ends with '/'");
        }
        this.m_welcomeFiles = welcomeFiles;
        this.m_redirect = redirect;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.m_filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOG.debug("Apply welcome files filter...");
        if (this.m_welcomeFiles.length > 0 && request instanceof HttpServletRequest) {
            String servletPath = ((HttpServletRequest)request).getServletPath();
            String pathInfo = ((HttpServletRequest)request).getPathInfo();
            LOG.debug("Servlet path: " + servletPath);
            LOG.debug("Path info: " + pathInfo);
            if (pathInfo != null && pathInfo.endsWith("/") || servletPath != null && servletPath.endsWith("/")) {
                ServletContext servletContext = this.m_filterConfig.getServletContext();
                for (String welcomeFile : this.m_welcomeFiles) {
                    String welcomePath = URIUtil.addPaths((String)servletPath, (String)URIUtil.addPaths((String)pathInfo, (String)welcomeFile));
                    URL welcomeFileUrl = servletContext.getResource(welcomePath);
                    if (welcomeFileUrl == null) continue;
                    if (this.m_redirect && response instanceof HttpServletResponse) {
                        ((HttpServletResponse)response).sendRedirect(welcomeFile);
                        return;
                    }
                    RequestDispatcher requestDispatcher = request.getRequestDispatcher(welcomePath);
                    if (requestDispatcher == null) continue;
                    requestDispatcher.forward(request, response);
                    return;
                }
            }
        } else {
            if (this.m_welcomeFiles.length == 0) {
                LOG.debug("Welcome filter not applied as there are no welcome files configured.");
            }
            if (!(request instanceof HttpServletRequest)) {
                LOG.debug("Welcome filter not applied as the request is not an " + HttpServletRequest.class.getSimpleName());
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "welcomeFiles=" + Arrays.toString(this.m_welcomeFiles) + "}";
    }
}

