/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.servlet.ServletHandler;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.internal.HttpServiceRequestWrapper;
import org.ops4j.pax.web.service.internal.HttpServiceResponseWrapper;
import org.osgi.service.http.HttpContext;

class HttpServiceServletHandler
extends ServletHandler {
    private static final Log LOG = LogFactory.getLog(HttpServiceServletHandler.class);
    private final HttpContext m_httpContext;

    HttpServiceServletHandler(HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        this.m_httpContext = httpContext;
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatchMode) throws IOException, ServletException {
        HttpServiceResponseWrapper responseWrapper;
        HttpServiceRequestWrapper requestWrapper;
        if (request instanceof Request && request.getAttribute("org.ops4j.pax.web.service.internal.jettyRequest") == null) {
            request.setAttribute("org.ops4j.pax.web.service.internal.jettyRequest", (Object)request);
        }
        if (this.m_httpContext.handleSecurity((HttpServletRequest)(requestWrapper = new HttpServiceRequestWrapper(request)), (HttpServletResponse)(responseWrapper = new HttpServiceResponseWrapper(response)))) {
            super.handle(target, request, response, dispatchMode);
        } else if (!responseWrapper.isCommitted()) {
            if (!responseWrapper.isStatusSet()) {
                responseWrapper.sendError(401);
            } else {
                responseWrapper.sendError(responseWrapper.getStatus());
            }
        }
    }
}

