/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.File;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.swissbox.property.BundleContextPropertyResolver;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.internal.Configuration;
import org.ops4j.pax.web.service.internal.ConfigurationImpl;
import org.ops4j.pax.web.service.internal.DefaultPropertyResolver;
import org.ops4j.pax.web.service.internal.HttpServiceFactoryImpl;
import org.ops4j.pax.web.service.internal.HttpServiceProxy;
import org.ops4j.pax.web.service.internal.HttpServiceStarted;
import org.ops4j.pax.web.service.internal.JettyFactoryImpl;
import org.ops4j.pax.web.service.internal.ServerController;
import org.ops4j.pax.web.service.internal.ServerControllerImpl;
import org.ops4j.pax.web.service.internal.model.ServerModel;
import org.ops4j.pax.web.service.internal.util.JCLLogger;
import org.ops4j.util.property.DictionaryPropertyResolver;
import org.ops4j.util.property.FallbackPropertyResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.http.HttpService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator {
    private static final Log LOG = LogFactory.getLog(Activator.class);
    private final Lock m_lock = new ReentrantLock();
    private ServerController m_serverController;
    private ServerModel m_serverModel;
    private ServiceRegistration m_httpServiceFactoryReg;
    private Dictionary m_httpServiceFactoryProps;

    public Activator() {
        ClassLoader backup = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(Activator.class.getClassLoader());
        JCLLogger.init();
        Thread.currentThread().setContextClassLoader(backup);
    }

    public void start(BundleContext bundleContext) throws Exception {
        LOG.info("Starting pax http service");
        this.createServerController();
        this.createManagedService(bundleContext);
        this.createHttpServiceFactory(bundleContext);
        LOG.info("Started pax http service");
    }

    public void stop(BundleContext bundleContext) throws Exception {
        LOG.info("Stopping pax http service");
        if (this.m_serverController != null) {
            this.m_serverController.stop();
            this.m_serverController = null;
        }
        this.m_serverModel = null;
        LOG.info("Stopped pax http service");
    }

    private void createHttpServiceFactory(BundleContext bundleContext) {
        this.m_httpServiceFactoryReg = bundleContext.registerService(new String[]{HttpService.class.getName(), WebContainer.class.getName()}, (Object)new HttpServiceFactoryImpl(){

            HttpService createService(Bundle bundle) {
                return new HttpServiceProxy(new HttpServiceStarted(bundle, Activator.this.m_serverController, Activator.this.m_serverModel));
            }
        }, this.m_httpServiceFactoryProps);
    }

    private void createServerController() {
        this.m_serverModel = new ServerModel();
        this.m_serverController = new ServerControllerImpl(new JettyFactoryImpl(this.m_serverModel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createManagedService(final BundleContext bundleContext) {
        ManagedService managedService = new ManagedService(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void updated(Dictionary config) throws ConfigurationException {
                try {
                    Activator.this.m_lock.lock();
                    FallbackPropertyResolver resolver = config == null ? new BundleContextPropertyResolver(bundleContext, new DefaultPropertyResolver()) : new DictionaryPropertyResolver(config, new BundleContextPropertyResolver(bundleContext, new DefaultPropertyResolver()));
                    ConfigurationImpl configuration = new ConfigurationImpl(resolver);
                    Activator.this.m_serverController.configure(configuration);
                    Activator.this.determineServiceProperties(config, configuration, Activator.this.m_serverController.getHttpPort(), Activator.this.m_serverController.getHttpSecurePort());
                    if (Activator.this.m_httpServiceFactoryReg != null) {
                        Activator.this.m_httpServiceFactoryReg.setProperties(Activator.this.m_httpServiceFactoryProps);
                    }
                }
                finally {
                    Activator.this.m_lock.unlock();
                }
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", "org.ops4j.pax.web");
        bundleContext.registerService(ManagedService.class.getName(), (Object)managedService, props);
        try {
            this.m_lock.lock();
            if (!this.m_serverController.isConfigured()) {
                try {
                    managedService.updated(null);
                }
                catch (ConfigurationException ignore) {
                    LOG.error("Internal error. Cannot set initial configuration resolver.", ignore);
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
    }

    private void determineServiceProperties(Dictionary managedConfig, Configuration config, Integer httpPort, Integer httpSecurePort) {
        Hashtable<String, Object> toPropagate = new Hashtable<String, Object>();
        if (managedConfig != null && !managedConfig.isEmpty()) {
            Enumeration enumeration = managedConfig.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                toPropagate.put(key, managedConfig.get(key));
            }
        }
        this.setProperty(toPropagate, "org.osgi.service.http.enabled", config.isHttpEnabled());
        this.setProperty(toPropagate, "org.osgi.service.http.port", config.getHttpPort());
        this.setProperty(toPropagate, "org.osgi.service.http.secure.enabled", config.isHttpEnabled());
        this.setProperty(toPropagate, "org.osgi.service.http.port.secure", config.getHttpSecurePort());
        this.setProperty(toPropagate, "org.osgi.service.http.useNIO", config.useNIO());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.clientauthneeded", config.isClientAuthNeeded());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.clientauthwanted", config.isClientAuthWanted());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.keystore", config.getSslKeystore());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.keystore.type", config.getSslKeystoreType());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.password", null);
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.keypassword", null);
        this.setProperty(toPropagate, "javax.servlet.context.tempdir", config.getTemporaryDirectory());
        this.setProperty(toPropagate, "org.ops4j.pax.web.session.timeout", config.getSessionTimeout());
        this.setProperty(toPropagate, "org.ops4j.pax.web.listening.addresses", config.getListeningAddresses());
        this.setProperty(toPropagate, "org.osgi.service.http.port", httpPort);
        this.setProperty(toPropagate, "org.osgi.service.http.port.secure", httpSecurePort);
        this.m_httpServiceFactoryProps = toPropagate;
    }

    private void setProperty(Hashtable<String, Object> properties, String name, Object value) {
        if (value != null) {
            if (value instanceof File) {
                properties.put(name, ((File)value).getAbsolutePath());
            } else if (value instanceof Object[]) {
                properties.put(name, Activator.join(",", (Object[])value));
            } else {
                properties.put(name, value.toString());
            }
        } else {
            properties.remove(name);
        }
    }

    private static String join(String token, Object[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int x = 0; x < array.length - 1; ++x) {
            if (array[x] != null) {
                sb.append(array[x].toString());
            } else {
                sb.append("null");
            }
            sb.append(token);
        }
        sb.append(array[array.length - 1]);
        return sb.toString();
    }
}

