/* Copyright 2004, 2005, 2006 Acegi Technology Pty Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.security.adapters;

import org.springframework.security.GrantedAuthority;

import java.security.Principal;


/**
 * A {@link Principal} compatible  {@link org.springframework.security.Authentication} object.
 *
 * @author Ben Alex
 * @version $Id: PrincipalSpringSecurityUserToken.java 2217 2007-10-27 00:45:30Z luke_t $
 */
public class PrincipalSpringSecurityUserToken extends AbstractAdapterAuthenticationToken implements Principal {
    //~ Instance fields ================================================================================================

    private static final long serialVersionUID = 1L;
    private Object principal;
    private String password;
    private String username;

    //~ Constructors ===================================================================================================

    public PrincipalSpringSecurityUserToken(String key, String username, String password, GrantedAuthority[] authorities,
        Object principal) {
        super(key, authorities);
        this.username = username;
        this.password = password;
        this.principal = principal;
    }

    //~ Methods ========================================================================================================

    public Object getCredentials() {
        return this.password;
    }

    public String getName() {
        return this.username;
    }

    public Object getPrincipal() {
        if (this.principal == null) {
            return this.username;
        }

        return this.principal;
    }
}
