/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.servlet.Context;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.internal.JettyServerWrapper;
import org.ops4j.pax.web.service.internal.model.ContextModel;
import org.ops4j.pax.web.service.internal.model.ServerModel;

class JettyServerHandlerCollection
extends HandlerCollection {
    private final ServerModel m_serverModel;

    JettyServerHandlerCollection(ServerModel serverModel) {
        NullArgumentException.validateNotNull(serverModel, "Service model");
        this.m_serverModel = serverModel;
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        ContextModel matched = this.m_serverModel.matchPathToContext(target);
        if (matched != null) {
            Context context = ((JettyServerWrapper)this.getServer()).getContext(matched.getHttpContext());
            try {
                context.handle(target, request, response, dispatch);
            }
            catch (EofException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            if (!response.isCommitted()) {
                response.flushBuffer();
            }
        }
    }
}

