/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal.model;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.internal.model.ContextModel;
import org.ops4j.pax.web.service.internal.model.Model;
import org.ops4j.pax.web.service.internal.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletModel
extends Model {
    private final Servlet m_servlet;
    private final String m_alias;
    private final String[] m_urlPatterns;
    private final Map<String, String> m_initParams;
    private final String m_name;

    public ServletModel(ContextModel contextModel, Servlet servlet, String alias, Dictionary initParams) {
        this(contextModel, servlet, null, new String[]{ServletModel.aliasAsUrlPattern(alias)}, ServletModel.validateAlias(alias), initParams);
    }

    public ServletModel(ContextModel contextModel, Servlet servlet, String servletName, String[] urlPatterns, String alias, Dictionary initParams) {
        super(contextModel);
        NullArgumentException.validateNotNull(servlet, "Servlet");
        NullArgumentException.validateNotNull(urlPatterns, "Url patterns");
        if (urlPatterns.length == 0) {
            throw new IllegalArgumentException("Registered servlet must have at least one url pattern");
        }
        this.m_urlPatterns = Path.normalizePatterns(urlPatterns);
        this.m_alias = alias;
        this.m_servlet = servlet;
        this.m_initParams = ServletModel.convertToMap(initParams);
        String name = servletName;
        if (name == null) {
            name = this.m_initParams.get("servlet-name");
        }
        if (name == null) {
            name = this.getId();
        }
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public String[] getUrlPatterns() {
        return this.m_urlPatterns;
    }

    public String getAlias() {
        return this.m_alias;
    }

    public Servlet getServlet() {
        return this.m_servlet;
    }

    public Map<String, String> getInitParams() {
        return this.m_initParams;
    }

    private static String validateAlias(String alias) {
        NullArgumentException.validateNotNull(alias, "Alias");
        if (!alias.startsWith("/")) {
            throw new IllegalArgumentException("Alias does not start with slash (/)");
        }
        if (alias.length() > 1 && alias.endsWith("/")) {
            throw new IllegalArgumentException("Alias ends with slash (/)");
        }
        return alias;
    }

    private static Map<String, String> convertToMap(Dictionary dictionary) {
        HashMap<String, String> converted = new HashMap<String, String>();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            try {
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    String value = (String)dictionary.get(key);
                    converted.put(key, value);
                }
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Invalid init params for the servlet. The key and value must be Strings.");
            }
        }
        return converted;
    }

    private static String aliasAsUrlPattern(String alias) {
        String urlPattern = alias;
        if (urlPattern != null && !urlPattern.equals("/") && !urlPattern.contains("*")) {
            urlPattern = urlPattern.endsWith("/") ? urlPattern + "*" : urlPattern + "/*";
        }
        return urlPattern;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + "id=" + this.getId() + ",name=" + this.getName() + ",urlPatterns=" + Arrays.toString(this.m_urlPatterns) + ",alias=" + this.m_alias + ",servlet=" + this.m_servlet + ",initParams=" + this.m_initParams + ",context=" + this.getContextModel() + "}";
    }
}

