/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.samt.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.log4j.Logger;
import sernet.gs.service.RuntimeCommandException;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.GenericCommand;
import sernet.verinice.interfaces.ICachedCommand;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.ControlGroup;
import sernet.verinice.model.iso27k.IControl;
import sernet.verinice.samt.service.FindSamtGroup;

public class TotalSecurityFigureISA2Command
extends GenericCommand
implements ICachedCommand {
    private static final Logger LOG = Logger.getLogger(TotalSecurityFigureISA2Command.class);
    private boolean resultInjectedFromCache = false;
    private static final long serialVersionUID = 201502111531L;
    private Integer auditDbId = null;
    private Double totalSecurityFigure;
    private int controlCount = 0;
    private Double targetMaturity;
    private Double averageTargetMaturity;

    public TotalSecurityFigureISA2Command(Integer samtGroup) {
        this.auditDbId = samtGroup;
        this.targetMaturity = 0.0;
        this.averageTargetMaturity = 0.0;
    }

    public void execute() {
        try {
            if (!this.resultInjectedFromCache) {
                FindSamtGroup command = new FindSamtGroup(true, this.auditDbId);
                command = (FindSamtGroup)this.getCommandService().executeCommand((ICommand)command);
                ControlGroup controlGroup = command.getSelfAssessmentGroup();
                int matSum = this.getMaturitySum(controlGroup);
                if (this.controlCount != 0) {
                    this.totalSecurityFigure = (double)matSum / (double)this.controlCount;
                    this.targetMaturity = this.targetMaturity / (double)this.controlCount;
                    this.averageTargetMaturity = this.averageTargetMaturity / (double)this.controlCount;
                } else {
                    this.totalSecurityFigure = 0.0;
                    this.targetMaturity = 0.0;
                    this.averageTargetMaturity = 0.0;
                }
            }
        }
        catch (CommandException e) {
            throw new RuntimeCommandException((Throwable)e);
        }
    }

    public int getMaturitySum(ControlGroup controlgroup) {
        int maturitySum = 0;
        for (CnATreeElement child : controlgroup.getChildren()) {
            if (child instanceof IControl) {
                IControl control = (IControl)child;
                int maturity = control.getMaturity();
                if (maturity > -1 && this.getTargetMaturity(control) > 0) {
                    maturitySum += maturity;
                    this.targetMaturity = this.targetMaturity + Double.valueOf(String.valueOf(this.reduceToTargetMaturity(control)));
                    ++this.controlCount;
                    this.averageTargetMaturity = this.averageTargetMaturity + (double)this.getTargetMaturity(control);
                }
                if (-2 != maturity && LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding maturity " + String.valueOf(maturity) + "from Control:\t" + control.getTitle()));
                }
            }
            if (!(child instanceof ControlGroup)) continue;
            ControlGroup cg = (ControlGroup)child;
            maturitySum += this.getMaturitySum(cg);
        }
        return maturitySum;
    }

    private int reduceToTargetMaturity(IControl control) {
        int target = this.getTargetMaturity(control);
        if (control.getMaturity() > target) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Reducing " + control.getTitle() + "(" + control.getMaturity() + ") to" + control.getThreshold2()));
            }
            return target;
        }
        return control.getMaturity();
    }

    @Deprecated
    public Double getResult() {
        return this.getRoundedValue(this.totalSecurityFigure);
    }

    public String getCacheID() {
        StringBuilder cacheID = new StringBuilder();
        cacheID.append(((Object)((Object)this)).getClass().getSimpleName());
        cacheID.append(String.valueOf(this.auditDbId));
        return cacheID.toString();
    }

    public void injectCacheResult(Object result) {
        if (result instanceof Object[]) {
            Object[] arr = (Object[])result;
            this.totalSecurityFigure = (Double)arr[0];
            this.targetMaturity = (Double)arr[1];
            this.averageTargetMaturity = (Double)arr[2];
            this.resultInjectedFromCache = true;
        }
    }

    public Object getCacheableResult() {
        return new Object[]{(double)this.totalSecurityFigure, (double)this.targetMaturity, (double)this.averageTargetMaturity};
    }

    @Deprecated
    public Double getTargetMaturity() {
        return this.getRoundedValue(this.targetMaturity);
    }

    @Deprecated
    public Double getAverageMaturity() {
        return this.getRoundedValue(this.averageTargetMaturity);
    }

    private int getTargetMaturity(IControl control) {
        return control.getThreshold2();
    }

    private double getRoundedValue(double d) {
        BigDecimal bd = new BigDecimal(d);
        bd = bd.setScale(2, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public Double getTotalSecurityFigure() {
        return this.getResult();
    }

    public Double getReducedTargetMaturity() {
        return this.getTargetMaturity();
    }

    public Double getAverageMaximumAchieveableMaturity() {
        return this.getAverageMaturity();
    }
}

