/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.samt.service;

import org.apache.log4j.Logger;
import sernet.gs.service.RuntimeCommandException;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.GenericCommand;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.ControlGroup;
import sernet.verinice.model.iso27k.IControl;
import sernet.verinice.samt.service.FindSamtGroup;

public class TotalSecurityFigureCommand
extends GenericCommand {
    private static final Logger log = Logger.getLogger(TotalSecurityFigureCommand.class);
    private Integer auditDbId = null;
    private Double totalSecurityFigure;

    public TotalSecurityFigureCommand(Integer samtGroup) {
        this.auditDbId = samtGroup;
    }

    public void execute() {
        try {
            FindSamtGroup command = new FindSamtGroup(true, this.auditDbId);
            command = (FindSamtGroup)this.getCommandService().executeCommand((ICommand)command);
            ControlGroup controlGroup = command.getSelfAssessmentGroup();
            Integer weightedMaturity = this.getWeightedMaturity(controlGroup);
            Integer weightedThreshold = this.getWeightedThreshold(controlGroup);
            this.totalSecurityFigure = 1.0;
            if (weightedThreshold != 0) {
                this.totalSecurityFigure = (double)weightedMaturity.intValue() / (double)weightedThreshold.intValue();
            }
        }
        catch (CommandException e) {
            throw new RuntimeCommandException((Throwable)e);
        }
    }

    public Double getResult() {
        return this.totalSecurityFigure > 1.0 ? new Double(1.0) : this.totalSecurityFigure;
    }

    public Integer getWeightedMaturity(ControlGroup cg) {
        int maturity = 0;
        for (CnATreeElement child : cg.getChildren()) {
            IControl control;
            if (child instanceof IControl) {
                control = (IControl)child;
                maturity += this.getWeightedMaturity(control).intValue();
            }
            if (!(child instanceof ControlGroup)) continue;
            control = (ControlGroup)child;
            maturity += this.getWeightedMaturity((ControlGroup)control).intValue();
        }
        return maturity;
    }

    public Integer getWeightedMaturity(IControl contr) {
        Integer weightedThreshold;
        int value = 0;
        int maturity = contr.getMaturity();
        if (-1 != maturity && -2 != maturity && (value = contr.getMaturity() * contr.getWeight2()) > (weightedThreshold = this.getWeightedThreshold(contr))) {
            value = weightedThreshold;
        }
        return value;
    }

    public Integer getWeightedThreshold(ControlGroup cg) {
        int maturity = 0;
        for (CnATreeElement child : cg.getChildren()) {
            IControl control;
            if (child instanceof IControl) {
                control = (IControl)child;
                maturity += this.getWeightedThreshold(control).intValue();
            }
            if (!(child instanceof ControlGroup)) continue;
            control = (ControlGroup)child;
            maturity += this.getWeightedThreshold((ControlGroup)control).intValue();
        }
        return maturity;
    }

    public Integer getWeightedThreshold(IControl contr) {
        int value = 0;
        int maturity = contr.getMaturity();
        if (-1 != maturity) {
            value = contr.getThreshold2() * contr.getWeight2();
        }
        return value;
    }
}

