/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.samt.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import sernet.gs.service.NumericStringComparator;
import sernet.verinice.interfaces.GenericCommand;
import sernet.verinice.interfaces.IAuthAwareCommand;
import sernet.verinice.interfaces.IAuthService;
import sernet.verinice.interfaces.IBaseDao;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.ControlGroup;
import sernet.verinice.model.samt.SamtTopic;

public class LoadAllSamtTopics
extends GenericCommand
implements IAuthAwareCommand {
    private static final Logger log = Logger.getLogger(LoadAllSamtTopics.class);
    private transient IAuthService authService;
    private Integer id;
    private List<SamtTopic> result;

    public LoadAllSamtTopics(ControlGroup cg) {
        this.id = cg.getDbId();
    }

    public void execute() {
        IBaseDao dao = this.getDaoFactory().getDAO(ControlGroup.class);
        ControlGroup cg = (ControlGroup)dao.findById((Serializable)this.id);
        ArrayList<SamtTopic> resultList = new ArrayList<SamtTopic>();
        this.loadSamtTopics(cg, resultList);
        this.result = resultList;
    }

    private void loadSamtTopics(ControlGroup cg, List<SamtTopic> result) {
        if (cg == null) {
            return;
        }
        for (CnATreeElement e : cg.getChildren()) {
            if (e instanceof SamtTopic) {
                SamtTopic st = (SamtTopic)e;
                if (!st.getTitle().startsWith("0")) {
                    result.add(st);
                }
                this.hydrate(st);
                continue;
            }
            if (e instanceof ControlGroup) {
                this.loadSamtTopics((ControlGroup)e, result);
                continue;
            }
            log.warn((Object)("found unexpected child for control group: " + e));
        }
    }

    private void hydrate(SamtTopic st) {
        st.getTitle();
        st.getWeight2();
        st.getThreshold2();
        st.getMaturity();
    }

    public List<SamtTopic> getAllSamtTopics() {
        Collections.sort(this.result, new Comparator<CnATreeElement>(){

            @Override
            public int compare(CnATreeElement o1, CnATreeElement o2) {
                NumericStringComparator comparator = new NumericStringComparator();
                return comparator.compare((Object)o1.getTitle(), (Object)o2.getTitle());
            }
        });
        return this.result;
    }

    public IAuthService getAuthService() {
        return this.authService;
    }

    public void setAuthService(IAuthService service) {
        this.authService = service;
    }
}

