/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.samt.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import sernet.verinice.interfaces.GenericCommand;
import sernet.verinice.interfaces.IAuthAwareCommand;
import sernet.verinice.interfaces.IAuthService;
import sernet.verinice.interfaces.IBaseDao;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.ControlGroup;

public class FindSamtGroup
extends GenericCommand
implements IAuthAwareCommand {
    private static final Logger log = Logger.getLogger(FindSamtGroup.class);
    private transient IAuthService authService;
    private ControlGroup selfAssessmentGroup = null;
    private boolean hydrateParent;
    private Integer dbId = null;

    public FindSamtGroup() {
        this(false);
    }

    public FindSamtGroup(boolean hydrateParent) {
        this.hydrateParent = hydrateParent;
    }

    public FindSamtGroup(boolean hydrateParent, Integer orgDbId) {
        this.hydrateParent = hydrateParent;
        this.dbId = orgDbId;
    }

    public void setHydrateParent(boolean hydrateParent) {
        this.hydrateParent = hydrateParent;
    }

    public void setDbId(Integer dbId) {
        this.dbId = dbId;
    }

    public void execute() {
        List<ControlGroup> resultList = this.fillResultList();
        if (!resultList.isEmpty() && resultList.size() > 1 && this.dbId != null) {
            for (ControlGroup controlGroup : resultList) {
                if (!this.isParent((CnATreeElement)controlGroup, this.dbId)) continue;
                this.selfAssessmentGroup = controlGroup;
                this.hydrate(this.selfAssessmentGroup);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("result: " + this.selfAssessmentGroup));
                }
                return;
            }
        }
        if (resultList != null && !resultList.isEmpty()) {
            log.debug((Object)("number of self assessment groups " + FindSamtGroup.nullSaveSize(resultList)));
            this.selfAssessmentGroup = resultList.get(0);
            this.hydrate(this.selfAssessmentGroup);
            if (log.isDebugEnabled()) {
                log.debug((Object)("result: " + this.selfAssessmentGroup));
            }
        }
    }

    private List<ControlGroup> fillResultList() {
        List<ControlGroup> controlGroupList;
        IBaseDao dao = this.getDaoFactory().getDAO(ControlGroup.class);
        StringBuilder sbHql = new StringBuilder();
        sbHql.append("select distinct controlGroup from ControlGroup as controlGroup");
        String hql = sbHql.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("hql: " + hql));
        }
        if ((controlGroupList = dao.findByQuery(hql, null)) == null) {
            controlGroupList = Collections.emptyList();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("number of controlGroups " + FindSamtGroup.nullSaveSize(controlGroupList)));
        }
        ArrayList<ControlGroup> resultList = new ArrayList<ControlGroup>();
        for (ControlGroup controlGroup : controlGroupList) {
            if (!this.isAudit(controlGroup.getParent()) || !this.isSamtTopicCollection(controlGroup.getChildren())) continue;
            resultList.add(controlGroup);
        }
        return resultList;
    }

    private boolean isParent(CnATreeElement child, Integer parentId) {
        if (child.getParent() == null) {
            return false;
        }
        if (child.getParent().getDbId().equals(parentId)) {
            return true;
        }
        return this.isParent(child.getParent(), parentId);
    }

    private boolean isAudit(CnATreeElement parent) {
        return parent != null && "audit".equals(parent.getTypeId());
    }

    private boolean isSamtTopicCollection(Collection<CnATreeElement> collection) {
        boolean isSamtTopicSet = true;
        for (CnATreeElement element : collection) {
            if (element != null && !(isSamtTopicSet = "controlgroup".equals(element.getTypeId()) ? this.isSamtTopicCollection(element.getChildren()) : "samt_topic".equals(element.getTypeId()))) break;
        }
        return isSamtTopicSet;
    }

    private void hydrate(ControlGroup selfAssessmentGroup) {
        selfAssessmentGroup.getTitle();
        if (this.hydrateParent) {
            selfAssessmentGroup.getParent().getTitle();
        }
    }

    private static int nullSaveSize(List<ControlGroup> controlGroupList) {
        int size = 0;
        if (controlGroupList != null) {
            size = controlGroupList.size();
        }
        return size;
    }

    public ControlGroup getSelfAssessmentGroup() {
        return this.selfAssessmentGroup;
    }

    public IAuthService getAuthService() {
        return this.authService;
    }

    public void setAuthService(IAuthService service) {
        this.authService = service;
    }
}

