/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.samt.service;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import sernet.gs.service.CsvFile;
import sernet.gs.service.RuntimeCommandException;
import sernet.hui.common.connect.HitroUtil;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.GenericCommand;
import sernet.verinice.interfaces.IAuthAwareCommand;
import sernet.verinice.interfaces.IAuthService;
import sernet.verinice.interfaces.IBaseDao;
import sernet.verinice.interfaces.IChangeLoggingCommand;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.iso27k.IItem;
import sernet.verinice.model.common.ChangeLogEntry;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.Permission;
import sernet.verinice.model.iso27k.Audit;
import sernet.verinice.model.iso27k.AuditGroup;
import sernet.verinice.model.iso27k.ControlGroup;
import sernet.verinice.model.iso27k.IControl;
import sernet.verinice.model.iso27k.IISO27kGroup;
import sernet.verinice.model.iso27k.ISO27KModel;
import sernet.verinice.model.iso27k.Organization;
import sernet.verinice.model.samt.SamtTopic;
import sernet.verinice.service.commands.CreateElement;
import sernet.verinice.service.iso27k.ImportCatalog;
import sernet.verinice.service.iso27k.ItemControlTransformer;

public class CreateSelfAssessment
extends GenericCommand
implements IChangeLoggingCommand,
IAuthAwareCommand {
    private static final Logger log = Logger.getLogger(CreateSelfAssessment.class);
    private CsvFile csvFile;
    private String titleOrganization;
    private String title;
    private ISO27KModel model;
    private Organization organization;
    private AuditGroup auditGroup;
    private Audit isaAudit;
    private String stationId;
    private List<CnATreeElement> changedElements;
    private transient IAuthService authService;

    public CreateSelfAssessment(ISO27KModel model, String titleOrganization, String title) {
        this.titleOrganization = titleOrganization;
        this.title = title;
        this.model = model;
        this.stationId = ChangeLogEntry.STATION_ID;
    }

    public CreateSelfAssessment(AuditGroup auditGroup, String titleOrganization, String title) {
        this.titleOrganization = titleOrganization;
        this.title = title;
        this.auditGroup = auditGroup;
        this.stationId = ChangeLogEntry.STATION_ID;
    }

    public void execute() {
        try {
            this.changedElements = new ArrayList<CnATreeElement>();
            if (this.auditGroup == null) {
                this.organization = this.saveNewOrganisation((CnATreeElement)this.model, this.titleOrganization);
                this.changedElements.add((CnATreeElement)this.organization);
                this.auditGroup = this.getAuditGroup((CnATreeElement)this.organization);
                this.changedElements.add((CnATreeElement)this.auditGroup);
            }
            this.isaAudit = new Audit((CnATreeElement)this.auditGroup, true);
            if (this.title != null) {
                this.isaAudit.setTitel(this.title);
            }
            this.addPermissions((CnATreeElement)this.isaAudit);
            this.auditGroup.addChild((CnATreeElement)this.isaAudit);
            IBaseDao auditDao = this.getDaoFactory().getDAO(Audit.class);
            auditDao.saveOrUpdate((Object)this.isaAudit);
            this.changedElements.add((CnATreeElement)this.isaAudit);
            this.changedElements.addAll(this.isaAudit.getChildren());
            Collection<IItem> itemCollection = this.getItemCollection();
            ControlGroup controlGroup = this.getControlGroup((CnATreeElement)this.isaAudit);
            this.addPermissions((CnATreeElement)controlGroup);
            this.importCatalogItems((CnATreeElement)controlGroup, itemCollection);
            IBaseDao orgDao = this.getDaoFactory().getDAO(Organization.class);
            if (this.organization != null) {
                orgDao.saveOrUpdate((Object)this.organization);
            } else {
                IBaseDao dao = this.getDaoFactory().getDAO(Audit.class);
                dao.saveOrUpdate((Object)this.isaAudit);
                this.organization = this.findOrganization((CnATreeElement)this.isaAudit);
                this.organization = (Organization)orgDao.findById((Serializable)this.organization.getDbId());
            }
            IBaseDao daoLink = this.getDaoFactory().getDAO(CnALink.class);
            auditDao.flush();
            CnALink link = new CnALink((CnATreeElement)this.organization, (CnATreeElement)this.isaAudit, "rel_org_audit", null);
            this.organization.addLinkDown(link);
            this.isaAudit.addLinkUp(link);
            daoLink.saveOrUpdate((Object)link);
            Set isaCategories = controlGroup.getChildren().stream().filter(child -> "controlgroup".equals(child.getTypeId())).collect(Collectors.toSet());
            for (CnATreeElement category : isaCategories) {
                link = new CnALink((CnATreeElement)this.isaAudit, category, "rel_audit_controlgroup", null);
                this.isaAudit.addLinkDown(link);
                category.addLinkUp(link);
                daoLink.saveOrUpdate((Object)link);
            }
        }
        catch (CommandException e) {
            log.error((Object)"Error while creating self assesment", (Throwable)e);
            throw new RuntimeCommandException("Error while creating self assesment: " + e.getMessage());
        }
        catch (IOException e) {
            log.error((Object)"I-/O-Error while creating self assesment", (Throwable)e);
            throw new RuntimeCommandException("I-/O-Error while creating self assesment: " + e.getMessage());
        }
    }

    public Organization saveNewOrganisation(CnATreeElement container, String title) throws CommandException {
        String title0;
        String string = title0 = title != null ? title : null;
        if (title0 == null) {
            title0 = HitroUtil.getInstance().getTypeFactory().getMessage("org");
        }
        CreateElement saveCommand = new CreateElement(container, Organization.class, title0, false, true);
        saveCommand = (CreateElement)this.getCommandService().executeCommand((ICommand)saveCommand);
        Organization child = (Organization)saveCommand.getNewElement();
        container.addChild((CnATreeElement)child);
        child.setParentAndScope(container);
        return child;
    }

    private Organization findOrganization(CnATreeElement element) {
        CnATreeElement parent = element.getParent();
        if (parent instanceof Organization) {
            return (Organization)parent;
        }
        if (parent != null) {
            return this.findOrganization(parent);
        }
        return null;
    }

    private void addPermissions(CnATreeElement element) {
        HashSet<Permission> auditPerms = new HashSet<Permission>();
        auditPerms.add(Permission.createPermission((CnATreeElement)element, (String)this.authService.getUsername(), (boolean)true, (boolean)true));
        element.setPermissions(auditPerms);
    }

    private void importCatalogItems(CnATreeElement group, Collection<IItem> itemCollection) {
        for (IItem item : itemCollection) {
            CnATreeElement element = null;
            if (item.getItems() != null && item.getItems().size() > 0) {
                element = (CnATreeElement)ItemControlTransformer.transformToGroup((IItem)item, (IISO27kGroup)new ControlGroup());
                element.setParentAndScope(group);
                this.importCatalogItems(element, item.getItems());
            } else {
                element = (CnATreeElement)ItemControlTransformer.transformGeneric((IItem)item, (IControl)new SamtTopic());
                element.setParentAndScope(group);
            }
            this.addPermissions(element);
            group.addChild(element);
            this.changedElements.add(element);
        }
    }

    private Collection<IItem> getItemCollection() throws IOException, CommandException {
        if (this.csvFile == null) {
            String relativePath = "resources/add/real/path/to/samt-catalog.csv";
            InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(relativePath);
            if (is == null) {
                throw new FileNotFoundException("Relative path: " + relativePath + " not found by ..getClassLoader().getResource(..)");
            }
            this.csvFile = new CsvFile(is);
        }
        ImportCatalog catalogCommand = new ImportCatalog(this.csvFile.getFileContent());
        catalogCommand = (ImportCatalog)this.getCommandService().executeCommand((ICommand)catalogCommand);
        return catalogCommand.getCatalog().getRoot().getItems();
    }

    private AuditGroup getAuditGroup(CnATreeElement selfAssessment) {
        AuditGroup auditGroup0 = null;
        Set elementSet = selfAssessment.getChildren();
        for (CnATreeElement element : elementSet) {
            if (!(element instanceof AuditGroup)) continue;
            auditGroup0 = (AuditGroup)element;
            break;
        }
        return auditGroup0;
    }

    private ControlGroup getControlGroup(CnATreeElement selfAssessment) {
        ControlGroup controlGroup = null;
        Set elementSet = selfAssessment.getChildren();
        for (CnATreeElement element : elementSet) {
            if (!(element instanceof ControlGroup)) continue;
            controlGroup = (ControlGroup)element;
            break;
        }
        return controlGroup;
    }

    public ISO27KModel getModel() {
        return this.model;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public AuditGroup getAuditGroup() {
        return this.auditGroup;
    }

    public Audit getIsaAudit() {
        return this.isaAudit;
    }

    public void setCsvFile(CsvFile csvFile) {
        this.csvFile = csvFile;
    }

    public int getChangeType() {
        return 1;
    }

    public List<CnATreeElement> getChangedElements() {
        return this.changedElements;
    }

    public String getStationId() {
        return this.stationId;
    }

    public IAuthService getAuthService() {
        return this.authService;
    }

    public void setAuthService(IAuthService service) {
        this.authService = service;
    }
}

