/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.samt.rcp;

import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import sernet.gs.service.RetrieveInfo;
import sernet.gs.service.Retriever;
import sernet.gs.ui.rcp.main.bsi.views.chart.ChartView;
import sernet.gs.ui.rcp.main.bsi.views.chart.IChartGenerator;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.bsi.IBSIModelListener;
import sernet.verinice.model.common.ChangeLogEntry;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.ControlGroup;
import sernet.verinice.model.iso27k.IISO27KModelListener;
import sernet.verinice.model.iso27k.ISO27KModel;
import sernet.verinice.rcp.IAttachedToPerspective;
import sernet.verinice.samt.service.FindSamtGroup;

public class SpiderChartView
extends ChartView
implements IAttachedToPerspective {
    private static final Logger LOG = Logger.getLogger(SpiderChartView.class);
    public static final String ID = "sernet.verinice.samt.rcp.SpiderChartView";
    private ICommandService commandService;

    public String getRightID() {
        return "showchartview";
    }

    protected IChartGenerator getDefaultChartGenerator() {
        return this.samtProgressChart;
    }

    protected void createMenus() {
    }

    protected void setDescription() {
    }

    protected CnATreeElement getDefaultElement() {
        FindSamtGroup command = new FindSamtGroup();
        try {
            command = (FindSamtGroup)this.getCommandService().executeCommand((ICommand)command);
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Error while executing FindSamtGroup command", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            String message = "Error while executing FindSamtGroup command";
            LOG.error((Object)"Error while executing FindSamtGroup command", (Throwable)e);
            throw new RuntimeException("Error while executing FindSamtGroup command", e);
        }
        return command.getSelfAssessmentGroup();
    }

    protected synchronized void pageSelectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.isCnATreeElement(selection)) {
            ControlGroup group;
            CnATreeElement selectedElement = (CnATreeElement)((IStructuredSelection)selection).getFirstElement();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Selection changed, selected element: " + selectedElement));
            }
            if ((group = this.getChartControlGroup(selectedElement)) != null) {
                if (this.element != null && selectedElement == this.element) {
                    return;
                }
                this.element = group;
                this.drawChart();
            }
        }
    }

    private boolean isCnATreeElement(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        Object firstSelection = ((IStructuredSelection)selection).getFirstElement();
        return firstSelection instanceof CnATreeElement;
    }

    private ControlGroup getChartControlGroup(CnATreeElement selection) {
        ControlGroup group = null;
        if (this.isControlType(selection)) {
            if ("audit".equals(selection.getParent().getTypeId()) && "controlgroup".equals(selection.getTypeId())) {
                group = (ControlGroup)selection;
            } else {
                RetrieveInfo ri = new RetrieveInfo();
                ri.setParent(true);
                CnATreeElement parent = Retriever.retrieveElement((CnATreeElement)selection.getParent(), (RetrieveInfo)ri);
                group = this.getChartControlGroup(parent);
            }
        } else if (selection != null && "audit".equals(selection.getTypeId())) {
            group = this.getControlGroup(selection);
        }
        return group;
    }

    private ControlGroup getControlGroup(CnATreeElement selfAssessment) {
        ControlGroup controlGroup = null;
        Set elementSet = selfAssessment.getChildren();
        for (CnATreeElement element : elementSet) {
            if (!(element instanceof ControlGroup)) continue;
            controlGroup = (ControlGroup)element;
            break;
        }
        return controlGroup;
    }

    private boolean isControlType(CnATreeElement selection) {
        return selection != null && ("controlgroup".equals(selection.getTypeId()) || "control".equals(selection.getTypeId()) || "samt_topic".equals(selection.getTypeId()));
    }

    public ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.createCommandServive();
        }
        return this.commandService;
    }

    private ICommandService createCommandServive() {
        return ServiceFactory.lookupCommandService();
    }

    public String getPerspectiveId() {
        return "sernet.verinice.samt.rcp.SamtPerspective";
    }

    protected ChartView.ChangeListener createChangeListener() {
        return new SamtChartListener();
    }

    class SamtChartListener
    extends ChartView.ChangeListener
    implements IBSIModelListener,
    IISO27KModelListener {
        SamtChartListener() {
            super((ChartView)SpiderChartView.this);
        }

        public void childAdded(CnATreeElement category, CnATreeElement child) {
        }

        public void childChanged(CnATreeElement child) {
            SpiderChartView.this.drawChart();
        }

        public void childRemoved(CnATreeElement category, CnATreeElement child) {
        }

        public void databaseChildAdded(CnATreeElement child) {
        }

        public void databaseChildChanged(CnATreeElement child) {
            SpiderChartView.this.drawChart();
        }

        public void databaseChildRemoved(CnATreeElement child) {
        }

        public void databaseChildRemoved(ChangeLogEntry entry) {
        }

        public void modelRefresh(Object object) {
            SpiderChartView.this.drawChart();
        }

        public void modelReload(ISO27KModel newModel) {
            SpiderChartView.this.drawChart();
        }

        public void modelRefresh() {
            SpiderChartView.this.drawChart();
        }

        public void modelReload(BSIModel newModel) {
            SpiderChartView.this.drawChart();
        }
    }
}

