/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.samt.rcp;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import sernet.gs.service.VeriniceCharset;
import sernet.gs.ui.rcp.main.CnAWorkspace;
import sernet.verinice.samt.rcp.Messages;

public final class SamtWorkspace
extends CnAWorkspace {
    private static final Logger LOG = Logger.getLogger(SamtWorkspace.class);
    private static volatile SamtWorkspace instance;
    public static final String RESOURCES_PATH = "resources";
    public static final String CONF_PATH = "conf";
    public static final String SAMT_CATALOG_FILE_NAME;
    public static final String SAMT_CATALOG_PREVIOUS_FILE_NAME;

    static {
        SAMT_CATALOG_FILE_NAME = Messages.SamtWorkspace_0;
        SAMT_CATALOG_PREVIOUS_FILE_NAME = Messages.SamtCatalogPreviousFileName;
    }

    private SamtWorkspace() {
    }

    public static SamtWorkspace getInstance() {
        if (instance == null) {
            instance = new SamtWorkspace();
        }
        return instance;
    }

    public synchronized void createSelfAssessmemtCatalog(String fileName) throws IOException {
        String inputPath = RESOURCES_PATH + File.separatorChar + fileName;
        String ouputPath = CONF_PATH + File.separatorChar + fileName;
        try {
            this.createTextFile(inputPath, VeriniceCharset.CHARSET_UTF_8, this.getWorkdir(), ouputPath, null);
        }
        catch (RuntimeException e) {
            LOG.error((Object)("Error while saving samt catalog file in conf dir. Input path: " + inputPath + ", output path: " + ouputPath), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("Error while saving samt catalog file in conf dir. Input path: " + inputPath + ", output path: " + ouputPath), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

