/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.samt.rcp;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.IDecoration;
import sernet.gs.service.Retriever;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.Audit;
import sernet.verinice.model.iso27k.ControlGroup;
import sernet.verinice.model.samt.SamtTopic;

public class IsaDecoratorUtil {
    private static final BigDecimal MAX_SCORE = new BigDecimal("3.0");
    private static final BigDecimal GREEN_SCORE_COEFFICIENT = new BigDecimal("0.9");
    private static final BigDecimal YELLOW_SCORE_COEFFICIENT = new BigDecimal("0.7");
    private static final int SCALE = 2;

    static DecoratorColor decoratorColor(SamtTopic isaControl) {
        int maturity = IsaDecoratorUtil.getMaturity(isaControl);
        int targetMaturity = IsaDecoratorUtil.getTargetMaturity(isaControl);
        if (targetMaturity < TargetMaturity.MIN.value()) {
            return DecoratorColor.NULL;
        }
        return IsaDecoratorUtil.computeDecoratorColor(maturity, targetMaturity);
    }

    static DecoratorColor decoratorColor(ControlGroup controlGroup) {
        ControlGroup hydratedControlGroup = (ControlGroup)Retriever.checkRetrieveElement((CnATreeElement)controlGroup);
        int averageMaturity = IsaDecoratorUtil.getAverageMaturity(hydratedControlGroup);
        int averageTargetMaturity = IsaDecoratorUtil.getAverageTargetMaturity(hydratedControlGroup);
        if (averageTargetMaturity < TargetMaturity.MIN.value()) {
            return DecoratorColor.NULL;
        }
        return IsaDecoratorUtil.computeDecoratorColor(averageMaturity, averageTargetMaturity);
    }

    static DecoratorColor decoratorColor(Audit audit) {
        BigDecimal score = IsaDecoratorUtil.resultScore(audit);
        if (score.compareTo(GREEN_SCORE_COEFFICIENT.multiply(MAX_SCORE)) > 0) {
            return DecoratorColor.GREEN;
        }
        if (score.compareTo(YELLOW_SCORE_COEFFICIENT.multiply(MAX_SCORE)) > 0) {
            return DecoratorColor.YELLOW;
        }
        return DecoratorColor.RED;
    }

    private static DecoratorColor computeDecoratorColor(int maturity, int targetMaturity) {
        assert (maturity == Maturity.NOT_EDITED.value() || maturity == Maturity.NOT_APPLICABLE.value() || maturity >= Maturity.MIN.value() && maturity <= Maturity.MAX.value());
        assert (targetMaturity >= TargetMaturity.MIN.value() && targetMaturity <= TargetMaturity.MAX.value());
        DecoratorColor decoratorColor = maturity == Maturity.NOT_EDITED.value ? DecoratorColor.RED : (maturity == Maturity.NOT_APPLICABLE.value() ? DecoratorColor.NULL : (maturity <= targetMaturity - 2 ? DecoratorColor.RED : (maturity == targetMaturity - 1 ? DecoratorColor.YELLOW : (maturity >= targetMaturity ? DecoratorColor.GREEN : DecoratorColor.NULL))));
        return decoratorColor;
    }

    static BigDecimal resultScore(Audit audit) {
        Audit hydratedAudit = (Audit)Retriever.checkRetrieveChildren((CnATreeElement)audit);
        ControlGroup topLevelControlGroup = hydratedAudit.getControlGroup();
        topLevelControlGroup = (ControlGroup)Retriever.checkRetrieveChildren((CnATreeElement)topLevelControlGroup);
        HashSet<SamtTopic> isaControls = new HashSet<SamtTopic>();
        for (CnATreeElement element : topLevelControlGroup.getChildren()) {
            if (!(element instanceof ControlGroup)) continue;
            ControlGroup controlGroup = (ControlGroup)element;
            controlGroup = (ControlGroup)Retriever.checkRetrieveChildren((CnATreeElement)controlGroup);
            isaControls.addAll(IsaDecoratorUtil.getChildrenOfTypeIsaControl(controlGroup));
        }
        int accumulatedMaturity = 0;
        int count = 0;
        for (SamtTopic isaControl : isaControls) {
            isaControl = (SamtTopic)Retriever.checkRetrieveElement((CnATreeElement)isaControl);
            int maturity = IsaDecoratorUtil.getMaturity(isaControl);
            int targetMaturity = IsaDecoratorUtil.getTargetMaturity(isaControl);
            if (maturity == Maturity.NOT_APPLICABLE.value()) continue;
            if (maturity == Maturity.NOT_EDITED.value()) {
                maturity = 0;
            }
            if (maturity > targetMaturity) {
                maturity = targetMaturity;
            }
            accumulatedMaturity += maturity;
            ++count;
        }
        if (count == 0) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(accumulatedMaturity).divide(BigDecimal.valueOf(count), 2, RoundingMode.HALF_UP);
    }

    static boolean isGrandchildOfAudit(ControlGroup controlGroup) {
        CnATreeElement parent = controlGroup.getParent();
        CnATreeElement grandparent = parent.getParent();
        return grandparent instanceof Audit;
    }

    static boolean isGreatGrandchildOfAudit(SamtTopic isaControl) {
        CnATreeElement parent = isaControl.getParent();
        CnATreeElement grandparent = parent.getParent();
        CnATreeElement greatGrandparent = grandparent.getParent();
        return greatGrandparent instanceof Audit;
    }

    static boolean hasIsaControlChild(Audit audit) {
        ControlGroup topLevelControlGroup = audit.getControlGroup();
        return IsaDecoratorUtil.hasIsaControl((CnATreeElement)topLevelControlGroup);
    }

    private static boolean hasIsaControl(CnATreeElement element) {
        CnATreeElement whithChilds = Retriever.checkRetrieveChildren((CnATreeElement)element);
        for (CnATreeElement child : whithChilds.getChildren()) {
            if (!(child instanceof SamtTopic)) continue;
            return true;
        }
        for (CnATreeElement child : whithChilds.getChildren()) {
            if (!IsaDecoratorUtil.hasIsaControl(child)) continue;
            return true;
        }
        return false;
    }

    static void addOverlay(DecoratorColor color, IDecoration decoration) {
        ImageCache cache = ImageCache.getInstance();
        switch (color) {
            case NULL: {
                decoration.addOverlay(cache.getImageDescriptor(IconOverlay.EMPTY.getPath()));
                break;
            }
            case GREEN: {
                decoration.addOverlay(cache.getImageDescriptor(IconOverlay.GREEN.getPath()));
                break;
            }
            case YELLOW: {
                decoration.addOverlay(cache.getImageDescriptor(IconOverlay.YELLOW.getPath()));
                break;
            }
            case RED: {
                decoration.addOverlay(cache.getImageDescriptor(IconOverlay.RED.getPath()));
                break;
            }
            default: {
                decoration.addOverlay(cache.getImageDescriptor(IconOverlay.EMPTY.getPath()));
            }
        }
    }

    private static Set<SamtTopic> getChildrenOfTypeIsaControl(ControlGroup controlGroup) {
        HashSet<SamtTopic> isaControls = new HashSet<SamtTopic>();
        for (CnATreeElement element : controlGroup.getChildren()) {
            if (!(element instanceof SamtTopic)) continue;
            isaControls.add((SamtTopic)element);
        }
        return isaControls;
    }

    private static int getMaturity(SamtTopic isaControl) {
        SamtTopic hydratedControl = (SamtTopic)Retriever.checkRetrieveElement((CnATreeElement)isaControl);
        return hydratedControl.getMaturity();
    }

    private static int getTargetMaturity(SamtTopic isaControl) {
        SamtTopic hydratedControl = (SamtTopic)Retriever.checkRetrieveElement((CnATreeElement)isaControl);
        return hydratedControl.getThreshold2();
    }

    private static int getAverageMaturity(ControlGroup controlGroup) {
        int accumulativeMaturity = 0;
        int count = 0;
        for (CnATreeElement child : controlGroup.getChildren()) {
            if (!(child instanceof SamtTopic)) continue;
            SamtTopic isaControl = (SamtTopic)child;
            int maturity = IsaDecoratorUtil.getMaturity(isaControl);
            int targetMaturity = IsaDecoratorUtil.getTargetMaturity(isaControl);
            if (maturity == Maturity.NOT_EDITED.value()) {
                maturity = 0;
            }
            if (maturity > targetMaturity) {
                maturity = targetMaturity;
            }
            if (maturity == Maturity.NOT_APPLICABLE.value()) continue;
            accumulativeMaturity += maturity;
            ++count;
        }
        if (count == 0) {
            return 0;
        }
        return accumulativeMaturity / count;
    }

    private static int getAverageTargetMaturity(ControlGroup controlGroup) {
        int accumulativeTargetMaturity = 0;
        int count = 0;
        for (CnATreeElement child : controlGroup.getChildren()) {
            if (!(child instanceof SamtTopic)) continue;
            accumulativeTargetMaturity += IsaDecoratorUtil.getTargetMaturity((SamtTopic)child);
            ++count;
        }
        if (count == 0) {
            return 0;
        }
        return accumulativeTargetMaturity / count;
    }

    static enum DecoratorColor {
        NULL,
        GREEN,
        YELLOW,
        RED;

    }

    private static enum IconOverlay {
        EMPTY("overlays/empty.png"),
        GREEN("overlays/dot_green.png"),
        YELLOW("overlays/dot_yellow.png"),
        RED("overlays/dot_red.png");

        private String path;

        private IconOverlay(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }

    private static enum Maturity {
        NOT_EDITED(-2),
        NOT_APPLICABLE(-1),
        MIN(0),
        MAX(5);

        private int value;

        private Maturity(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }

    private static enum TargetMaturity {
        MIN(2),
        MAX(4);

        private int value;

        private TargetMaturity(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }
}

