/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.samt.rcp;

import java.math.BigDecimal;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import sernet.gs.service.Retriever;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.Audit;
import sernet.verinice.samt.rcp.Activator;
import sernet.verinice.samt.rcp.IsaDecoratorUtil;

public class IsaDecoratorForAudit
extends LabelProvider
implements ILightweightLabelDecorator {
    private static final Logger logger = Logger.getLogger(IsaDecoratorForAudit.class);

    public void decorate(Object element, IDecoration decoration) {
        boolean preferenceEnabled = Activator.getDefault().getPreferenceStore().getBoolean("sernet.verinice.samt.rcp.isaResult");
        if (!preferenceEnabled || !(element instanceof Audit)) {
            return;
        }
        sernet.gs.ui.rcp.main.Activator.inheritVeriniceContextState();
        Audit audit = (Audit)Retriever.checkRetrieveChildren((CnATreeElement)((CnATreeElement)element));
        if (IsaDecoratorUtil.hasIsaControlChild(audit)) {
            IsaDecoratorUtil.DecoratorColor color = IsaDecoratorUtil.decoratorColor(audit);
            IsaDecoratorUtil.addOverlay(color, decoration);
            BigDecimal score = IsaDecoratorUtil.resultScore(audit);
            StringBuilder sb = new StringBuilder();
            sb.append(" [").append(String.format("%.2f", score)).append("]");
            decoration.addSuffix(sb.toString());
            logger.debug((Object)("Score: " + score + ", audit uuid: " + audit.getUuid()));
        }
    }
}

