/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.samt.rcp;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;
import sernet.gs.service.CsvFile;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.Audit;
import sernet.verinice.model.iso27k.AuditGroup;
import sernet.verinice.model.iso27k.ISO27KModel;
import sernet.verinice.model.iso27k.Organization;
import sernet.verinice.samt.rcp.Activator;
import sernet.verinice.samt.rcp.AddSelfAssessment;
import sernet.verinice.samt.rcp.SamtWorkspace;
import sernet.verinice.samt.service.CreateSelfAssessment;
import sernet.verinice.service.model.LoadModel;

public class CreateNewSelfAssessmentService {
    private static final Logger LOG = Logger.getLogger(CreateNewSelfAssessmentService.class);
    private ICommandService commandService;

    public ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.createCommandServive();
        }
        return this.commandService;
    }

    private ICommandService createCommandServive() {
        return ServiceFactory.lookupCommandService();
    }

    protected CsvFile getCsvFile() throws IOException {
        CsvFile csvFile = null;
        String fullSamtCatalogPath = this.getFullSamtCatalogPath();
        try {
            csvFile = new CsvFile(fullSamtCatalogPath, this.getCharset());
        }
        catch (RuntimeException e) {
            LOG.error((Object)("Error while reading samt catalog file from path: " + fullSamtCatalogPath), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            LOG.error((Object)("Error while reading samt catalog file from path: " + fullSamtCatalogPath), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            String message = "Error while reading samt catalog file from path: " + fullSamtCatalogPath;
            LOG.error((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
        return csvFile;
    }

    private Charset getCharset() {
        String charsetName = Activator.getDefault().getPreferenceStore().getString("sernet.verinice.samt.rcp.charset");
        if (charsetName == null || charsetName.equals("")) {
            charsetName = Activator.getDefault().getPreferenceStore().getDefaultString("sernet.verinice.samt.rcp.charset");
        }
        return Charset.forName(charsetName);
    }

    private String getFullSamtCatalogPath() {
        return new File(SamtWorkspace.getInstance().getConfDir(), Activator.getDefault().getPreferenceStore().getString("sernet.verinice.samt.rcp.catalogFilename")).getAbsolutePath();
    }

    public void createSelfAssessment() throws CommandException, IOException {
        this.createSelfAssessment(null);
    }

    public void createSelfAssessment(AuditGroup parent) throws CommandException, IOException {
        CreateSelfAssessment command;
        ISO27KModel model = null;
        if (parent == null) {
            LoadModel loadModel = new LoadModel(ISO27KModel.class);
            loadModel = (LoadModel)this.getCommandService().executeCommand((ICommand)loadModel);
            model = (ISO27KModel)loadModel.getModel();
            command = new CreateSelfAssessment(model, AddSelfAssessment.TITEL_ORGANIZATION, AddSelfAssessment.TITEL);
        } else {
            command = new CreateSelfAssessment(parent, AddSelfAssessment.TITEL_ORGANIZATION, AddSelfAssessment.TITEL);
        }
        command.setCsvFile(this.getCsvFile());
        command = (CreateSelfAssessment)this.getCommandService().executeCommand((ICommand)command);
        Organization organization = command.getOrganization();
        AuditGroup auditGroup = command.getAuditGroup();
        Audit isaAudit = command.getIsaAudit();
        if (parent == null) {
            CnAElementFactory.getModel((CnATreeElement)organization).childAdded((CnATreeElement)model, (CnATreeElement)organization);
            CnAElementFactory.getModel((CnATreeElement)organization).databaseChildAdded((CnATreeElement)organization);
        } else {
            CnAElementFactory.getModel((CnATreeElement)isaAudit).childAdded((CnATreeElement)auditGroup, (CnATreeElement)isaAudit);
            CnAElementFactory.getModel((CnATreeElement)isaAudit).databaseChildAdded((CnATreeElement)isaAudit);
        }
    }
}

