/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.samt.rcp;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import sernet.gs.service.Retriever;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.dialogs.CnATreeElementSelectionDialog;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.Audit;
import sernet.verinice.model.iso27k.ControlGroup;
import sernet.verinice.model.iso27k.IControl;
import sernet.verinice.rcp.InfoDialogWithShowToggle;
import sernet.verinice.samt.rcp.Messages;

public class AssignAllIsaTopics
implements IObjectActionDelegate,
RightEnabledUserInteraction {
    private static final Logger LOG = Logger.getLogger(AssignAllIsaTopics.class);
    private IWorkbenchPart targetPart;
    private List<CnATreeElement> selectedElementList = new LinkedList<CnATreeElement>();
    private int numberOfTopics = 0;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        CnATreeElementSelectionDialog dialog;
        IWorkbenchWindow window = this.targetPart.getSite().getWorkbenchWindow();
        CnATreeElement firstSelected = null;
        if (this.selectedElementList != null && !this.selectedElementList.isEmpty()) {
            firstSelected = this.selectedElementList.get(0);
        }
        if ((dialog = new CnATreeElementSelectionDialog(window.getShell(), "person-iso", firstSelected)).open() != 0) {
            return;
        }
        final List personList = dialog.getSelectedElements();
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Activator.inheritVeriniceContextState();
                    AssignAllIsaTopics.this.numberOfTopics = 0;
                    for (CnATreeElement element : AssignAllIsaTopics.this.selectedElementList) {
                        if (!(element instanceof Audit)) continue;
                        Audit audit = (Audit)element;
                        ControlGroup controlGroup = audit.getControlGroup();
                        AssignAllIsaTopics.this.linkChildren((CnATreeElement)controlGroup, personList);
                    }
                }
            });
            InfoDialogWithShowToggle.openInformation((String)Messages.AssignAllIsaTopics_0, (String)Messages.bind((String)Messages.AssignAllIsaTopics_1, (Object)this.numberOfTopics), (String)Messages.AssignAllIsaTopics_2, (String)"info_controls_linked");
        }
        catch (InvocationTargetException t) {
            LOG.error((Object)"Error while creating tasks.", (Throwable)t);
            ExceptionUtil.log((Throwable)t, (String)Messages.AssignAllIsaTopics_3);
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Error while creating tasks.", (Throwable)e);
            ExceptionUtil.log((Throwable)e, (String)Messages.AssignAllIsaTopics_3);
        }
    }

    private void linkChildren(CnATreeElement controlGroup, List<CnATreeElement> personList) {
        if (controlGroup != null && personList != null) {
            controlGroup = Retriever.checkRetrieveChildren((CnATreeElement)controlGroup);
            Set children = controlGroup.getChildren();
            for (CnATreeElement child : children) {
                if (child == null) continue;
                if ("controlgroup".equals(child.getTypeId())) {
                    this.linkChildren((CnATreeElement)((ControlGroup)child), personList);
                }
                if (!(child instanceof IControl)) continue;
                CnAElementHome.getInstance().createLinksAccordingToBusinessLogicAsync(child, personList, "rel_samttopic_person-iso_resp");
                ++this.numberOfTopics;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(this.checkRights());
        if (selection instanceof IStructuredSelection) {
            this.selectedElementList.clear();
            for (Object sel : (IStructuredSelection)selection) {
                if (!(sel instanceof CnATreeElement)) continue;
                this.selectedElementList.add((CnATreeElement)sel);
            }
        }
    }

    public boolean checkRights() {
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }

    public String getRightID() {
        return "assignallisatopics";
    }
}

