/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.samt.rcp;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import sernet.gs.ui.rcp.main.Activator;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.iso27k.rcp.Mutex;
import sernet.verinice.rcp.RightsEnabledActionDelegate;
import sernet.verinice.samt.rcp.CreateNewSelfAssessmentService;
import sernet.verinice.samt.rcp.Messages;
import sernet.verinice.samt.rcp.SamtView;

public class AddSelfAssessment
extends RightsEnabledActionDelegate
implements IViewActionDelegate,
RightEnabledUserInteraction {
    private static final Logger LOG = Logger.getLogger(AddSelfAssessment.class);
    public static final String TITEL_ORGANIZATION = Messages.AddSelfAssessment_0;
    public static final String TITEL = Messages.AddSelfAssessment_1;
    private SamtView samtView = null;
    private CreateNewSelfAssessmentService samtService = new CreateNewSelfAssessmentService();
    private static ISchedulingRule iSchedulingRule = new Mutex();

    public void init(IViewPart view) {
        if (view instanceof SamtView) {
            this.samtView = (SamtView)view;
        }
    }

    public void doRun(IAction action) {
        WorkspaceJob importJob = new WorkspaceJob(Messages.AddSelfAssessment_3){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                try {
                    try {
                        AddSelfAssessment.this.createSelfAssessment(monitor);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Could not create self-assessment", (Throwable)e);
                        status = new Status(4, "sernet.verinice.samt.rcp", Messages.AddSelfAssessment_2, (Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return status;
            }
        };
        JobScheduler.scheduleJob((WorkspaceJob)importJob, (ISchedulingRule)iSchedulingRule);
    }

    private void createSelfAssessment(IProgressMonitor monitor) throws CommandException, IOException {
        monitor.beginTask(Messages.AddSelfAssessment_4, -1);
        Activator.inheritVeriniceContextState();
        this.samtService.createSelfAssessment();
        monitor.setTaskName(Messages.AddSelfAssessment_5);
        if (Activator.getDefault().getPreferenceStore().getBoolean("sernet.verinice.samt.rcp.expandIsa") && this.samtView != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    AddSelfAssessment.this.samtView.expand();
                }
            });
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.isServerRunning()) {
            action.setEnabled(this.checkRights());
        }
    }

    public String getRightID() {
        return "addsecurityassessment";
    }
}

