/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.impl.security.permissionhandling;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.Permission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sernet.verinice.report.service.impl.security.permissionhandling.AbstractPermissionHandler;
import sernet.verinice.security.report.ReportSecurityContext;

public class SocketPermissionHandler
extends AbstractPermissionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SocketPermissionHandler.class);
    private ReportSecurityContext reportSecurityContext;

    public SocketPermissionHandler(ReportSecurityContext reportSecurityContext) {
        this.reportSecurityContext = reportSecurityContext;
    }

    public void handlePermission(Permission permission) {
        try {
            String serverHost = this.reportSecurityContext.getReportOptions().getServerURL().trim();
            URI serverHostURI = new URI(serverHost);
            if (permission.getName().equals(InetAddress.getLocalHost().getHostName())) {
                return;
            }
            if (permission.getName().startsWith("localhost") || permission.getName().startsWith("127.0.0.1")) {
                return;
            }
            if (permission.getName().startsWith(String.valueOf(serverHostURI.getHost()) + ":" + serverHostURI.getPort())) {
                return;
            }
            this.throwSecurityException(permission);
        }
        catch (UnknownHostException e) {
            LOG.error("Unable to determine local machines hostname", (Throwable)e);
            this.throwSecurityException(permission, e);
        }
        catch (URISyntaxException e) {
            LOG.error("ServerURI is not a valid uri", (Throwable)e);
        }
    }
}

