/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.impl.security.permissionhandling;

import java.security.Permission;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sernet.verinice.report.service.impl.security.Messages;
import sernet.verinice.report.service.impl.security.permissionhandling.AbstractPermissionHandler;

public class ReflectAndRuntimePermissionHandler
extends AbstractPermissionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectAndRuntimePermissionHandler.class);

    public void handlePermission(Permission permission) {
        if (!this.isRuntimePermissionWhitelisted(permission.getName())) {
            this.throwSecurityException(permission);
            if (LOG.isDebugEnabled()) {
                LOG.debug(Arrays.toString(Thread.currentThread().getStackTrace()));
            }
        } else {
            return;
        }
    }

    private boolean isRuntimePermissionWhitelisted(String permissionName) {
        boolean authorizedCall = false;
        for (Map.Entry entry : runtimeActionsWhitelist.entrySet()) {
            for (String value : (List)entry.getValue()) {
                if (permissionName.equals(value)) {
                    authorizedCall = this.stacktraceContains((String)entry.getKey());
                }
                if (authorizedCall) break;
            }
            if (authorizedCall) break;
        }
        if (!authorizedCall) {
            LOG.error(NLS.bind((String)Messages.REPORT_SECURITY_EXCEPTION_1, (Object[])new Object[]{permissionName, ""}));
        }
        return authorizedCall;
    }
}

