/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.impl.security.permissionhandling;

import java.io.File;
import java.io.IOException;
import java.security.Permission;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sernet.verinice.report.service.impl.security.permissionhandling.AbstractPermissionHandler;
import sernet.verinice.security.report.ReportSecurityContext;

public class FilePermissionHandler
extends AbstractPermissionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FilePermissionHandler.class);
    private static final String OSGI_INSTANCE_AREA = "osgi.instance.area";
    private static final String OSGI_CONFIGURATION_AREA = "osgi.configuration.area";
    private static final String SUFFIX_LOG_DIR = "log";
    private static final String SUFFIX_LOG_FILE = ".log";
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private static final String USER_HOME = "user.home";
    private ReportSecurityContext reportSecurityContext;

    public FilePermissionHandler(ReportSecurityContext securityContext) {
        this.reportSecurityContext = securityContext;
    }

    public void handlePermission(Permission permission) {
        if (permission.getActions().contains("delete") || permission.getActions().contains("write")) {
            if (("file:" + permission.getName()).startsWith(String.valueOf(System.getProperty(OSGI_INSTANCE_AREA)) + ".metadata" + File.separator + ".plugins" + File.separator + "org.eclipse.core.runtime" + File.separator + ".settings")) {
                this.throwSecurityException(permission);
            }
            if (permission.getName().startsWith(this.reportSecurityContext.getLogFileLocation())) {
                return;
            }
            if (this.reportSecurityContext.getReportOptions().getOutputFile().getAbsolutePath().equals(permission.getName())) {
                return;
            }
            if (("file:" + permission.getName()).equals(String.valueOf(System.getProperty(OSGI_INSTANCE_AREA)) + SUFFIX_LOG_DIR)) {
                return;
            }
            if (("file:" + permission.getName()).equals(String.valueOf(this.getCanonicalFile(System.getProperty(OSGI_INSTANCE_AREA))) + SUFFIX_LOG_DIR)) {
                return;
            }
            if (("file:" + permission.getName()).startsWith(String.valueOf(System.getProperty(OSGI_INSTANCE_AREA)) + SUFFIX_LOG_DIR)) {
                return;
            }
            if (("file:" + permission.getName()).startsWith(String.valueOf(this.getCanonicalFile(System.getProperty(OSGI_INSTANCE_AREA))) + SUFFIX_LOG_DIR)) {
                return;
            }
            if (permission.getName().equals(String.valueOf(this.getCanonicalFile(System.getProperty(OSGI_INSTANCE_AREA))) + File.separator + ".metadata" + File.separator + SUFFIX_LOG_FILE)) {
                return;
            }
            if (permission.getName().equals(String.valueOf(System.getProperty(OSGI_INSTANCE_AREA)) + File.separator + ".metadata" + File.separator + SUFFIX_LOG_FILE)) {
                return;
            }
            if (("file:" + permission.getName()).startsWith(this.getCanonicalFile(System.getProperty(OSGI_CONFIGURATION_AREA)))) {
                return;
            }
            if (("file:" + permission.getName()).startsWith(System.getProperty(OSGI_CONFIGURATION_AREA))) {
                return;
            }
            if (permission.getName().startsWith(this.getCanonicalFile(System.getProperty(JAVA_IO_TMPDIR)))) {
                return;
            }
            if (permission.getName().startsWith(System.getProperty(JAVA_IO_TMPDIR))) {
                return;
            }
            if (permission.getName().startsWith(String.valueOf(this.getCanonicalFile(System.getProperty(USER_HOME))) + File.separator + ".java" + File.separator + "fonts")) {
                return;
            }
            if (permission.getName().startsWith(String.valueOf(System.getProperty(USER_HOME)) + File.separator + ".java" + File.separator + "fonts")) {
                return;
            }
            if (permission.getName().startsWith(FilenameUtils.getFullPath((String)this.getCanonicalFile(this.reportSecurityContext.getReportOptions().getOutputFile().getAbsolutePath())))) {
                return;
            }
            if (permission.getName().startsWith(FilenameUtils.getFullPath((String)this.reportSecurityContext.getReportOptions().getOutputFile().getAbsolutePath()))) {
                return;
            }
            if (SystemUtils.IS_OS_MAC_OSX && permission.getName().startsWith("/private/var/folders/")) {
                return;
            }
            this.throwSecurityException(permission);
        }
    }

    private String getCanonicalFile(String fileName) {
        try {
            File f = new File(fileName);
            String canonicalPath = f.getCanonicalPath();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Canonical filename for:\t" + fileName + " is:\t" + canonicalPath);
            }
            return canonicalPath;
        }
        catch (IOException e) {
            LOG.debug("Can not determine canonical path of:\t" + fileName, (Throwable)e);
            return fileName;
        }
    }
}

