/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.impl.security;

import java.io.FilePermission;
import java.lang.reflect.ReflectPermission;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.security.Permission;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.logging.LoggingPermission;
import sernet.verinice.interfaces.report.IReportPermissionHandler;
import sernet.verinice.report.service.impl.security.permissionhandling.DefaultPermissionHandler;
import sernet.verinice.report.service.impl.security.permissionhandling.FilePermissionHandler;
import sernet.verinice.report.service.impl.security.permissionhandling.NetPermissionHandler;
import sernet.verinice.report.service.impl.security.permissionhandling.NullPermissionHandler;
import sernet.verinice.report.service.impl.security.permissionhandling.OSGIPermissionHandler;
import sernet.verinice.report.service.impl.security.permissionhandling.PropertyPermissionHandler;
import sernet.verinice.report.service.impl.security.permissionhandling.ReflectAndRuntimePermissionHandler;
import sernet.verinice.report.service.impl.security.permissionhandling.SocketPermissionHandler;
import sernet.verinice.security.report.ReportSecurityContext;

public class ReportSecurityPermissionManager {
    private Map<IReportPermissionHandler.PermissionClassname, IReportPermissionHandler> permissionHandlerMap = null;
    private ReportSecurityContext reportSecurityContext;
    static Map<String, List<String>> allowedPermissionsAndActionsMap = new HashMap<String, List<String>>();
    private ReflectAndRuntimePermissionHandler reflectAndRuntimeHandler = new ReflectAndRuntimePermissionHandler();

    static {
        allowedPermissionsAndActionsMap.put(RuntimePermission.class.getCanonicalName(), Arrays.asList(new String[0]));
        allowedPermissionsAndActionsMap.put(LoggingPermission.class.getCanonicalName(), Arrays.asList("control"));
        allowedPermissionsAndActionsMap.put(NetPermission.class.getCanonicalName(), Arrays.asList("specifyStreamHandler"));
        allowedPermissionsAndActionsMap.put("org.eclipse.equinox.log.LogPermission", Arrays.asList("*"));
    }

    public ReportSecurityPermissionManager(ReportSecurityContext reportSecurityContext) {
        this.reportSecurityContext = reportSecurityContext;
        this.initHandlerMap();
    }

    private Map<IReportPermissionHandler.PermissionClassname, IReportPermissionHandler> initHandlerMap() {
        if (this.permissionHandlerMap == null) {
            this.permissionHandlerMap = new HashMap<IReportPermissionHandler.PermissionClassname, IReportPermissionHandler>();
        }
        this.permissionHandlerMap.put(IReportPermissionHandler.PermissionClassname.FILE, new FilePermissionHandler(this.reportSecurityContext));
        this.permissionHandlerMap.put(IReportPermissionHandler.PermissionClassname.NET, new NetPermissionHandler());
        this.permissionHandlerMap.put(IReportPermissionHandler.PermissionClassname.NULL, new NullPermissionHandler());
        this.permissionHandlerMap.put(IReportPermissionHandler.PermissionClassname.OTHER, new DefaultPermissionHandler(allowedPermissionsAndActionsMap));
        this.permissionHandlerMap.put(IReportPermissionHandler.PermissionClassname.PROPERTY, new PropertyPermissionHandler());
        this.permissionHandlerMap.put(IReportPermissionHandler.PermissionClassname.REFLECT, this.reflectAndRuntimeHandler);
        this.permissionHandlerMap.put(IReportPermissionHandler.PermissionClassname.RUNTIME, this.reflectAndRuntimeHandler);
        this.permissionHandlerMap.put(IReportPermissionHandler.PermissionClassname.SOCKET, new SocketPermissionHandler(this.reportSecurityContext));
        this.permissionHandlerMap.put(IReportPermissionHandler.PermissionClassname.OSGI, new OSGIPermissionHandler());
        return this.permissionHandlerMap;
    }

    public Map<IReportPermissionHandler.PermissionClassname, IReportPermissionHandler> getPermissionHandlerMap() {
        return this.permissionHandlerMap;
    }

    private IReportPermissionHandler.PermissionClassname getClassType(Permission permission) {
        IReportPermissionHandler.PermissionClassname classname;
        Object object = classname = ReflectPermission.class.getCanonicalName().equals(permission.getClass().getCanonicalName()) ? IReportPermissionHandler.PermissionClassname.REFLECT : null;
        if (classname == null) {
            Object object2 = classname = RuntimePermission.class.getCanonicalName().equals(permission.getClass().getCanonicalName()) ? IReportPermissionHandler.PermissionClassname.RUNTIME : null;
        }
        if (classname == null) {
            Object object3 = classname = permission.getClass().getCanonicalName().startsWith("org.osgi.framework") ? IReportPermissionHandler.PermissionClassname.OSGI : null;
        }
        if (classname == null) {
            Object object4 = classname = PropertyPermission.class.getCanonicalName().equals(permission.getClass().getCanonicalName()) ? IReportPermissionHandler.PermissionClassname.PROPERTY : null;
        }
        if (classname == null) {
            Object object5 = classname = FilePermission.class.getCanonicalName().equals(permission.getClass().getCanonicalName()) ? IReportPermissionHandler.PermissionClassname.FILE : null;
        }
        if (classname == null) {
            Object object6 = classname = SocketPermission.class.getCanonicalName().equals(permission.getClass().getCanonicalName()) ? IReportPermissionHandler.PermissionClassname.SOCKET : null;
        }
        if (classname == null) {
            Object object7 = classname = NetPermission.class.getCanonicalName().equals(permission.getClass().getCanonicalName()) ? IReportPermissionHandler.PermissionClassname.NET : null;
        }
        if (classname == null) {
            Object object8 = classname = allowedPermissionsAndActionsMap.containsKey(permission.getClass().getCanonicalName()) ? IReportPermissionHandler.PermissionClassname.OTHER : null;
        }
        if (classname == null) {
            classname = IReportPermissionHandler.PermissionClassname.NULL;
        }
        return classname;
    }

    public IReportPermissionHandler getHandlerForPermission(Permission permission) {
        IReportPermissionHandler.PermissionClassname classname = this.getClassType(permission);
        return this.getPermissionHandlerMap().get(classname);
    }
}

