/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.impl.security;

import java.security.Permission;
import sernet.verinice.interfaces.report.IReportPermissionHandler;
import sernet.verinice.report.service.impl.security.Messages;
import sernet.verinice.report.service.impl.security.ReportSecurityPermissionManager;
import sernet.verinice.security.report.ReportSecurityContext;
import sernet.verinice.security.report.ReportSecurityException;

public class ReportSecurityManager
extends SecurityManager {
    private boolean protectionEnabled = true;
    private static final String VERINICE_RUN_QUERY_METHOD = "org.eclipse.birt.report.engine.api.impl.RunAndRenderTask.run";
    private ReportSecurityContext reportSecurityContext;
    ReportSecurityPermissionManager permissionManager;

    public ReportSecurityManager(ReportSecurityContext reportSecurityContext) {
        this.reportSecurityContext = reportSecurityContext;
        this.permissionManager = new ReportSecurityPermissionManager(reportSecurityContext);
    }

    @Override
    public void checkPermission(Permission permission) {
        if (this.isCalledByRunQuery()) {
            if (!this.protectionEnabled) {
                return;
            }
            this.permissionSpecificHandling(permission);
        }
    }

    private void permissionSpecificHandling(Permission permission) {
        IReportPermissionHandler handler = this.permissionManager.getHandlerForPermission(permission);
        handler.handlePermission(permission);
    }

    @Override
    public void checkExec(String command) {
        if (!this.protectionEnabled) {
            return;
        }
        if (this.isCalledByRunQuery()) {
            throw new ReportSecurityException(Messages.UNAUTHORIZED_EXECUTION_CALL_DETECTED);
        }
    }

    protected synchronized void setProtectionEnabled(boolean protectionEnabled) {
        this.protectionEnabled = protectionEnabled;
    }

    private boolean isCalledByRunQuery() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            if (stackTraceElement.toString().startsWith(VERINICE_RUN_QUERY_METHOD)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected String getReportOutputName() {
        return this.reportSecurityContext.getTemplateMetaData().getOutputname();
    }
}

