/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.impl.security;

import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.script.element.IReportDesign;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sernet.verinice.interfaces.report.ReportTypeException;
import sernet.verinice.report.service.impl.security.Messages;
import sernet.verinice.report.service.impl.security.ReportSecurityManager;

public class ReportExecutionThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ReportExecutionThread.class);
    private ReportSecurityManager reportSecurityManager;
    private IRunAndRenderTask task;

    public ReportExecutionThread(IRunAndRenderTask task, ReportSecurityManager secureReportExecutionManager, boolean sandboxEnabled) {
        this.task = task;
        this.reportSecurityManager = secureReportExecutionManager;
        this.reportSecurityManager.setProtectionEnabled(sandboxEnabled);
    }

    @Override
    public void run() {
        SecurityManager old = System.getSecurityManager();
        System.setSecurityManager(this.reportSecurityManager);
        this.runUntrustedCode();
        this.reportSecurityManager.setProtectionEnabled(false);
        System.setSecurityManager(old);
    }

    private void runUntrustedCode() {
        try {
            try {
                this.task.setErrorHandlingOption(1);
                this.task.run();
                if (!this.task.getErrors().isEmpty()) {
                    this.handleExceptionsFromTask();
                }
            }
            catch (EngineException exception) {
                this.logException(exception);
                throw new ReportTypeException((Throwable)exception);
            }
        }
        finally {
            this.task.close();
        }
    }

    private void logException(EngineException exception) {
        IReportRunnable reportRunnable = this.task.getReportRunnable();
        IReportDesign designInstance = reportRunnable.getDesignInstance();
        IReportDesign report = designInstance.getReport();
        String qualifiedName = report.getQualifiedName();
        LOG.error(NLS.bind((String)Messages.REPORT_RENDER_EXCEPTION_0, (Object)qualifiedName), (Throwable)exception);
    }

    private void handleExceptionsFromTask() {
        for (Object error : this.task.getErrors()) {
            if (!(error instanceof EngineException)) continue;
            throw new ReportTypeException((Throwable)((EngineException)((Object)error)));
        }
    }
}

