/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sernet.verinice.interfaces.report.IOutputFormat;
import sernet.verinice.interfaces.report.IReportOptions;
import sernet.verinice.interfaces.report.IReportType;
import sernet.verinice.model.report.AbstractOutputFormat;
import sernet.verinice.model.report.ExcelOutputFormat;
import sernet.verinice.model.report.HTMLOutputFormat;
import sernet.verinice.model.report.ODSOutputFormat;
import sernet.verinice.model.report.ODTOutputFormat;
import sernet.verinice.model.report.PDFOutputFormat;
import sernet.verinice.model.report.ReportTemplateMetaData;
import sernet.verinice.model.report.WordOutputFormat;
import sernet.verinice.report.service.impl.BIRTReportService;
import sernet.verinice.report.service.impl.Messages;
import sernet.verinice.report.service.impl.TocHelper2;
import sernet.verinice.report.service.impl.security.ReportSecurityManager;
import sernet.verinice.security.report.ReportSecurityContext;

@Deprecated
public class UserReportType
implements IReportType {
    private static final Logger LOG = LoggerFactory.getLogger(UserReportType.class);
    private static final String VAR_ENGINE_ITERATIONS = "engineIterations";
    private static final String PROPERTYHANDLE_PAGEVARIABLE = "pageVariables";
    private URL reportDocument;
    private String reportFile = "";

    public String getReportFile() {
        return this.reportFile;
    }

    public void setReportFile(String reportFile) {
        this.reportFile = reportFile;
    }

    public String getDescription() {
        return Messages.UserReportType_1;
    }

    public String getId() {
        return "user";
    }

    public String getLabel() {
        return Messages.UserReportType_2;
    }

    public IOutputFormat[] getOutputFormats() {
        return new IOutputFormat[]{new PDFOutputFormat(), new HTMLOutputFormat(), new ExcelOutputFormat(), new WordOutputFormat(), new ODTOutputFormat(), new ODSOutputFormat()};
    }

    public void createReport(IReportOptions reportOptions) {
        URL reportDesign;
        BIRTReportService brs = new BIRTReportService();
        try {
            reportDesign = new File(this.reportFile).toURI().toURL();
        }
        catch (MalformedURLException e) {
            LOG.error("Could not load user supplied report file.", (Throwable)e);
            throw new RuntimeException("Could not load user report file.", e);
        }
        catch (IOException e) {
            LOG.error("Could not create reportDocument tmpFile.", (Throwable)e);
            throw new RuntimeException("Could create tmpFile for reportDocument.", e);
        }
        if (((AbstractOutputFormat)reportOptions.getOutputFormat()).isRenderOutput()) {
            ReportSecurityContext reportSecurityContext = new ReportSecurityContext(reportOptions, reportDesign, brs.getLogfile(), null);
            ReportSecurityManager secureReportExecutionManager = new ReportSecurityManager(reportSecurityContext);
            IRunAndRenderTask task = brs.createTask(reportSecurityContext.getRptDesignUrl(), reportOptions);
            task = brs.prepareTaskForRendering(task, reportOptions);
            int iterations = this.getEngineIterations(task);
            if (LOG.isDebugEnabled()) {
                LOG.debug("EngineIterations for UserTypeReport:\t" + iterations);
            }
            int i = 0;
            while (i < iterations) {
                brs.performRenderTask(task, secureReportExecutionManager);
                ++i;
            }
            TocHelper2.reset();
        } else {
            IDataExtractionTask task = brs.createExtractionTask(reportDesign);
            brs.extract(task, reportOptions, 1);
        }
    }

    public String getUseCaseID() {
        return "use_case_report_always";
    }

    private int getEngineIterations(IRunAndRenderTask task) {
        ReportDesignHandle dh = (ReportDesignHandle)task.getReportRunnable().getDesignHandle();
        Iterator iter = dh.getPropertyIterator();
        try {
            while (iter.hasNext()) {
                Object o = iter.next();
                PropertyHandle ph = (PropertyHandle)o;
                if (!ph.getPropertyDefn().getName().equals(PROPERTYHANDLE_PAGEVARIABLE)) continue;
                for (Object item : ph.getContents()) {
                    VariableElementHandle veh;
                    if (!(item instanceof VariableElementHandle) || !(veh = (VariableElementHandle)item).getVariableName().equals(VAR_ENGINE_ITERATIONS)) continue;
                    return Integer.parseInt(veh.getValue());
                }
            }
        }
        catch (NumberFormatException t) {
            LOG.error("Error while determing number of engine iterations", (Throwable)t);
        }
        return 1;
    }

    public void createReport(ReportTemplateMetaData report) {
    }
}

