/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TocHelper2 {
    private static int pageBreakCount = 0;
    private static int tocEntryCount = 0;
    private static int listOfTablesEntryCount = 0;
    private static int listOfFiguresEntryCount = 0;
    private static int engineIteration = 0;
    private static int pageStartCount = 0;
    private static int maxTocEntryLength = 0;
    private static final Logger LOG = LoggerFactory.getLogger(TocHelper2.class);
    private static Map<Integer, TocEntry<String, Integer>> loTMap = new HashMap<Integer, TocEntry<String, Integer>>();
    private static Map<Integer, TocEntry<String, Integer>> tocMap = new HashMap<Integer, TocEntry<String, Integer>>();
    private static Map<Integer, TocEntry<String, Integer>> loFMap = new HashMap<Integer, TocEntry<String, Integer>>();
    private static Map<Integer, String> pageHeadingsMap = new HashMap<Integer, String>();
    private static final Pattern REMOVE_TAGS;

    static {
        TocEntry dummyEntry = new TocEntry("Inhaltsverzeichnis braucht 2 Iterationen", -1);
        tocMap.put(tocEntryCount, dummyEntry);
        REMOVE_TAGS = Pattern.compile("<.+?>");
    }

    private TocHelper2() {
    }

    public static void increaseEngineIteration() {
        ++engineIteration;
    }

    public static void increasePageBreakCount() {
        ++pageBreakCount;
    }

    public static void increasePageStartCount() {
        if (engineIteration > 1) {
            ++pageStartCount;
        }
    }

    public static int getPageStartCount() {
        return pageStartCount;
    }

    public static int getPageBreakCount() {
        return pageBreakCount;
    }

    public static void reset() {
        switch (engineIteration) {
            case 1: {
                tocEntryCount = 0;
                listOfTablesEntryCount = 0;
                listOfFiguresEntryCount = 0;
                break;
            }
            case 2: {
                tocEntryCount = 0;
                listOfTablesEntryCount = 0;
                listOfFiguresEntryCount = 0;
                break;
            }
            case 3: {
                tocEntryCount = 0;
                listOfTablesEntryCount = 0;
                listOfFiguresEntryCount = 0;
                loFMap.clear();
                loTMap.clear();
                break;
            }
            case 4: {
                tocMap.clear();
                loFMap.clear();
                loTMap.clear();
                pageHeadingsMap.clear();
                pageBreakCount = 0;
                tocEntryCount = 0;
                listOfTablesEntryCount = 0;
                listOfFiguresEntryCount = 0;
                engineIteration = 0;
                pageStartCount = 0;
                break;
            }
        }
    }

    public static void resetTOC() {
        tocMap.clear();
        tocEntryCount = 0;
    }

    public static void addTocEntry(String entryTitle, Integer pageNumber) {
        String entryTitle0 = TocHelper2.removeTags(entryTitle);
        TocEntry entry = new TocEntry(entryTitle0, pageNumber);
        int entryNumberToPut = tocEntryCount;
        for (Map.Entry<Integer, TocEntry<String, Integer>> mapEntry : tocMap.entrySet()) {
            if (!mapEntry.getValue().getTitle().equals(entry.getTitle())) continue;
            entryNumberToPut = mapEntry.getKey();
        }
        if (!tocMap.containsValue(entry)) {
            tocMap.put(entryNumberToPut, entry);
            ++tocEntryCount;
        }
    }

    public static void addPageHeading(Integer page, String entry) {
        if (engineIteration > 2) {
            pageHeadingsMap.put(page, entry);
        }
    }

    public static String getPageHeading(Integer page) {
        if (pageHeadingsMap.containsKey(page) && engineIteration > 3) {
            return pageHeadingsMap.get(page);
        }
        return "";
    }

    public static String[] getTocLine(Integer i) {
        String[] tocEntryLine = new String[]{"dummyTitle", "dummyPage"};
        if (engineIteration >= 3) {
            TocEntry<String, Integer> entry = tocMap.get(i);
            tocEntryLine[0] = entry.getTitle();
            tocEntryLine[1] = String.valueOf(entry.getPageNumber());
        }
        return tocEntryLine;
    }

    public static int getTocItemCount() {
        return tocMap.size();
    }

    public static String[] getLoTLine(Integer i) {
        String[] lotEntryLine = new String[]{"", ""};
        if (engineIteration > 1 && i <= listOfTablesEntryCount) {
            TocEntry<String, Integer> entry = loTMap.get(i);
            String title = entry != null ? entry.getTitle() : null;
            Integer page = entry != null ? entry.getPageNumber() : null;
            lotEntryLine[0] = title != null ? title : "dummyTitle";
            lotEntryLine[1] = page != null ? page.toString() : "dummyPage";
        }
        return lotEntryLine;
    }

    public static String[] getLoFLine(Integer i) {
        String[] lofEntryLine = new String[]{"", ""};
        if (engineIteration > 1 && i <= listOfFiguresEntryCount) {
            TocEntry<String, Integer> entry = loFMap.get(i);
            String title = entry != null ? entry.getTitle() : null;
            Integer page = entry != null ? entry.getPageNumber() : null;
            lofEntryLine[0] = title != null ? title : "dummyTitle";
            lofEntryLine[1] = page != null ? page.toString() : "dummyPage";
        }
        return lofEntryLine;
    }

    public static int getListOfTablesItemCount() {
        return loTMap.size();
    }

    public static int getListOfFiguresItemCount() {
        return loFMap.size();
    }

    public static void addLoTEntry(String tableName, Integer pageNumber) {
        int entryNumberToPut = listOfTablesEntryCount;
        String entryToPut = tableName.trim();
        for (Map.Entry<Integer, TocEntry<String, Integer>> mapEntry : loTMap.entrySet()) {
            String mapEntryTitle;
            String entryTitle = tableName.substring(tableName.indexOf(58) + 1).trim();
            if (!entryTitle.equals(mapEntryTitle = mapEntry.getValue().getTitle().substring(mapEntry.getValue().getTitle().indexOf(":") + 1).trim())) continue;
            String preFix = mapEntry.getValue().getTitle().substring(0, mapEntry.getValue().getTitle().indexOf(":") + 1);
            entryToPut = String.valueOf(preFix.trim()) + " " + mapEntryTitle.trim();
            entryNumberToPut = mapEntry.getKey();
        }
        TocEntry entry = new TocEntry(entryToPut, pageNumber);
        if (!loTMap.containsValue(entry)) {
            loTMap.put(entryNumberToPut, entry);
        }
    }

    public static void addLoFEntry(String figureName, Integer pageNumber) {
        int entryNumberToPut = listOfFiguresEntryCount;
        String entryToPut = figureName.trim();
        for (Map.Entry<Integer, TocEntry<String, Integer>> mapEntry : loFMap.entrySet()) {
            String mapEntryTitle;
            String entryTitle = figureName.substring(figureName.indexOf(58) + 1).trim();
            if (!entryTitle.equals(mapEntryTitle = mapEntry.getValue().getTitle().substring(mapEntry.getValue().getTitle().indexOf(":") + 1).trim())) continue;
            String preFix = mapEntry.getValue().getTitle().substring(0, mapEntry.getValue().getTitle().indexOf(":") + 1);
            entryToPut = String.valueOf(preFix.trim()) + " " + mapEntryTitle.trim();
            entryNumberToPut = mapEntry.getKey();
        }
        TocEntry entry = new TocEntry(entryToPut, pageNumber);
        if (!loFMap.containsValue(entry)) {
            loFMap.put(entryNumberToPut, entry);
        }
    }

    public static void addTocEntry(String entryTitle, int indent, Integer pageNumber) {
        int maxChNrLength = 6;
        StringBuilder sb = new StringBuilder();
        String chapterNumber = null;
        String entryTitle0 = TocHelper2.removeTags(entryTitle);
        if (entryTitle0.contains(" ")) {
            String sub = entryTitle0.substring(0, entryTitle0.indexOf(32));
            Pattern pattern = Pattern.compile("\\d+.\\d*.*\\d*.*");
            Matcher m = pattern.matcher(sub);
            if (m.matches()) {
                chapterNumber = sub;
                if (chapterNumber.endsWith("0")) {
                    while (chapterNumber.endsWith("0")) {
                        chapterNumber = chapterNumber.substring(0, chapterNumber.length() - 1);
                    }
                }
                while (chapterNumber.length() < 6) {
                    chapterNumber = String.valueOf(chapterNumber) + " ";
                }
            }
        }
        if (chapterNumber != null) {
            sb.append(String.valueOf(chapterNumber));
            entryTitle0 = entryTitle.substring(entryTitle.indexOf(32)).trim();
        }
        int i = 0;
        while (i < indent) {
            sb.append("     ");
            ++i;
        }
        sb.append(entryTitle0);
        TocHelper2.addTocEntry(sb.toString(), pageNumber);
    }

    public static int getMaxTocEntryLength() {
        return maxTocEntryLength;
    }

    public static String removeTags(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        Matcher m = REMOVE_TAGS.matcher(string);
        return m.replaceAll("");
    }

    public static int getLoTCount() {
        return listOfTablesEntryCount;
    }

    public static int getLoFCount() {
        return listOfFiguresEntryCount;
    }

    public static void increaseLoFCount() {
        if (engineIteration > 1) {
            ++listOfFiguresEntryCount;
        }
    }

    public static void increaseLoTCount() {
        if (engineIteration > 1) {
            ++listOfTablesEntryCount;
        }
    }

    public static String computeChapterNumber(String title) {
        String number = "";
        if (title.contains(" ")) {
            String prefix = title.substring(0, title.indexOf(32));
            try {
                int testInt = Integer.parseInt(prefix);
                number = String.valueOf(testInt);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return number;
    }

    public static void log(String msg) {
        LOG.error(msg);
    }

    public static void iterateList(List list) {
        for (Object o : list) {
            LOG.error(o.getClass().getCanonicalName());
        }
    }

    public static String getEngineIteration() {
        return String.valueOf(engineIteration);
    }

    public static void inspectObject(Object object) {
        TocHelper2.log(object.getClass().getCanonicalName());
    }

    public static String parseDate(String date, Locale locale) {
        SimpleDateFormat formatter = new SimpleDateFormat("EE, dd.MM.yyyy", locale);
        SimpleDateFormat destinationFormat = new SimpleDateFormat("dd.MM.yyyy", locale);
        formatter.setLenient(true);
        try {
            Date fDate = formatter.parse(date);
            return destinationFormat.format(fDate);
        }
        catch (ParseException e) {
            LOG.error("Error while parsing date", (Throwable)e);
            return date;
        }
    }

    public static String addTocPadding(String entry, boolean left) {
        return entry;
    }

    public static class TocEntry<TITLE, PAGENUMBER>
    implements Comparable<TocEntry<TITLE, PAGENUMBER>> {
        private final String title;
        private final Integer pagenumber;

        public TocEntry(String title, Integer pagenumber) {
            this.title = title;
            this.pagenumber = pagenumber;
        }

        public String getTitle() {
            return this.title;
        }

        public Integer getPageNumber() {
            return this.pagenumber;
        }

        public String toString() {
            return "<" + this.title + ", " + this.pagenumber.toString() + ">";
        }

        public boolean equals(Object entry) {
            if (!(entry instanceof TocEntry)) {
                return false;
            }
            return this.toString().equals(((TocEntry)entry).toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        @Override
        public int compareTo(TocEntry<TITLE, PAGENUMBER> o) {
            if (this.pagenumber > o.pagenumber) {
                return 1;
            }
            if (this.pagenumber < o.pagenumber) {
                return -1;
            }
            return 0;
        }
    }
}

