/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TocHelper {
    private static int pageNumber = 0;
    private static int tocPageCount = 0;
    private static int resetCount = 0;
    private static int finalTocPageCount = 0;
    private static List<String> finalItems = new ArrayList<String>();
    private static List<Integer> finalPages = new ArrayList<Integer>();
    private static List<String> items;
    private static List<Integer> pages;
    private static Logger log;

    static {
        finalItems.add("<em>TOC generation needs 2 more runs!</em>");
        finalPages.add(-1);
        items = new ArrayList<String>();
        pages = new ArrayList<Integer>();
        log = LoggerFactory.getLogger(TocHelper.class);
    }

    private TocHelper() {
    }

    public static int getTocCount() {
        return finalItems.size();
    }

    public static void addTocItem(String item, int depth) {
        if (!item.equals("")) {
            StringBuilder sb = new StringBuilder(depth + item.length());
            int i = 0;
            while (i < depth) {
                sb.append(" ");
                ++i;
            }
            sb.append(item);
            items.add(sb.toString());
            pages.add(pageNumber);
        }
    }

    public static String getTocItem(int i) {
        return finalItems.get(i);
    }

    public static Integer getTocItemPage(int i) {
        return resetCount == 2 ? finalPages.get(i) + finalTocPageCount : -1;
    }

    public static void startRun() {
        pageNumber = 0;
        tocPageCount = 0;
    }

    public static void endRun() {
        switch (++resetCount) {
            case 1: {
                finalItems.clear();
                finalPages.clear();
                finalItems.addAll(items);
                finalPages.addAll(pages);
                items.clear();
                pages.clear();
                break;
            }
            case 2: {
                finalItems.clear();
                finalPages.clear();
                finalItems.addAll(items);
                finalPages.addAll(pages);
                finalTocPageCount = tocPageCount;
                break;
            }
            case 3: {
                finalItems.clear();
                finalPages.clear();
                finalItems.add("<em>TOC generation needs 2 more runs!</em>");
                finalPages.add(-1);
                items.clear();
                pages.clear();
                resetCount = 0;
                break;
            }
        }
    }

    public static void increasePageNumber() {
        ++pageNumber;
    }

    public static void increaseTocPageCount() {
        ++tocPageCount;
    }

    public static void triggerLog(String msg) {
        log.debug(msg);
    }
}

