/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.impl;

import java.io.IOException;
import org.eclipse.birt.report.engine.api.EXCELRenderOption;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;
import sernet.verinice.interfaces.report.IOutputFormat;
import sernet.verinice.interfaces.report.IReportService;
import sernet.verinice.interfaces.report.IReportType;
import sernet.verinice.model.report.PropertyFileExistsException;
import sernet.verinice.model.report.ReportMetaDataException;
import sernet.verinice.model.report.ReportTemplateMetaData;
import sernet.verinice.oda.driver.Activator;
import sernet.verinice.report.service.impl.GenericReportType;

public class ReportService
implements IReportService {
    private IReportType[] reportTypes;

    public IReportType[] getReportTypes() {
        if (this.reportTypes == null) {
            this.reportTypes = new IReportType[]{new GenericReportType()};
        }
        return (IReportType[])this.reportTypes.clone();
    }

    public IOutputFormat getOutputFormat(String formatLabel) {
        return null;
    }

    public IOutputFormat[] getOutputFormats(String[] formatLabel) {
        return null;
    }

    public ReportTemplateMetaData[] getReportTemplates(String[] rptDesignFiles) throws IOException, ReportMetaDataException, PropertyFileExistsException {
        return null;
    }

    public IRenderOption getRenderOptions(String format) {
        if ("pdf".equalsIgnoreCase(format)) {
            return this.getPDFRenderOption();
        }
        if ("xls".equalsIgnoreCase(format)) {
            return this.getXLSRenderOption();
        }
        if ("doc".equalsIgnoreCase(format)) {
            return this.getDOCRenderOption();
        }
        if ("html".equalsIgnoreCase(format)) {
            return this.getHTMLRenderOption();
        }
        if ("odt".equalsIgnoreCase(format)) {
            return this.getODTRenderOption();
        }
        if ("ods".equalsIgnoreCase(format)) {
            return this.getODSRenderOption();
        }
        if ("docx".equalsIgnoreCase(format)) {
            return this.getDOXCRenderOption();
        }
        if ("xlsx".equalsIgnoreCase(format)) {
            return this.getXLSXRenderOption();
        }
        return null;
    }

    public String[] getClassificationHints() {
        return Activator.getDefault().getClassificationHints();
    }

    private IRenderOption getXLSXRenderOption() {
        RenderOption options = new RenderOption();
        options.setOutputFormat("xlsx");
        return options;
    }

    private IRenderOption getDOXCRenderOption() {
        RenderOption options = new RenderOption();
        options.setOutputFormat("docx");
        return options;
    }

    private IRenderOption getPDFRenderOption() {
        PDFRenderOption pdfOptions = new PDFRenderOption();
        pdfOptions.setOutputFormat("pdf");
        pdfOptions.setOption("pdfRenderOption.pageOverflow", (Object)4);
        return pdfOptions;
    }

    private IRenderOption getXLSRenderOption() {
        EXCELRenderOption excelOptions = new EXCELRenderOption();
        excelOptions.setOutputFormat("xls");
        return excelOptions;
    }

    private IRenderOption getDOCRenderOption() {
        RenderOption options = new RenderOption();
        options.setOutputFormat("doc");
        return options;
    }

    private IRenderOption getHTMLRenderOption() {
        HTMLRenderOption htmlOptions = new HTMLRenderOption();
        htmlOptions.setHtmlPagination(false);
        htmlOptions.setOutputFormat("html");
        htmlOptions.setImageDirectory(".");
        return htmlOptions;
    }

    private IRenderOption getODSRenderOption() {
        RenderOption options = new RenderOption();
        options.setOutputFormat("ods");
        return options;
    }

    private IRenderOption getODTRenderOption() {
        RenderOption options = new RenderOption();
        options.setOutputFormat("odt");
        return options;
    }
}

