/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.impl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.core.runtime.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sernet.verinice.interfaces.oda.IVeriniceOdaDriver;
import sernet.verinice.report.service.Activator;
import sernet.verinice.report.service.impl.BIRTReportService;
import sernet.verinice.report.service.impl.GenericReportType;

public final class ReportResourceLocator
implements IResourceLocator {
    private static final Logger log = LoggerFactory.getLogger(ReportResourceLocator.class);

    public URL findResource(ModuleHandle moduleHandle, String fileName, int type, Map appContext) {
        URL url = this.findByClassloader(fileName);
        if (url == null) {
            url = this.findInRepository(fileName);
        }
        if (url == null && log.isWarnEnabled()) {
            log.warn(String.format("Report resource '%s' could not neither be found through internal resource loader nor through the default one.", fileName));
        }
        return url;
    }

    public URL findResource(ModuleHandle moduleHandle, String fileName, int type) {
        URL url = this.findByClassloader(fileName);
        if (url == null) {
            url = this.findInRepository(fileName);
        }
        if (url == null && log.isWarnEnabled()) {
            log.warn(String.format("Report resource '%s' could not neither be found through internal resource loader nor through the default one.", fileName));
        }
        return url;
    }

    private URL findInRepository(String fileName) {
        try {
            URL url = this.getUrlFromLocalDirectory(fileName);
            if (url != null) {
                return url;
            }
            return this.getUrlFromRemoteSyncDirectory(fileName);
        }
        catch (MalformedURLException | URISyntaxException e) {
            log.error("Error building url for report properties.", (Throwable)e);
            return null;
        }
    }

    private URL getUrlFromLocalDirectory(String fileName) throws URISyntaxException, MalformedURLException {
        IVeriniceOdaDriver odaDriver = Activator.getDefault().getOdaDriver();
        URI locationConst = URIUtil.fromString((String)odaDriver.getLocalReportLocation());
        File propertyFile = new File(String.valueOf(URIUtil.toUnencodedString((URI)locationConst)) + File.separatorChar + fileName);
        if (propertyFile.exists()) {
            return propertyFile.toURI().toURL();
        }
        return null;
    }

    private URL getUrlFromRemoteSyncDirectory(String fileName) throws MalformedURLException {
        String depositPath = GenericReportType.getDepositPath("report_templates_remote");
        String fullFilePath = String.valueOf(depositPath) + fileName;
        URL url = new URL(fullFilePath);
        String path = url.getPath();
        File file = new File(path);
        if (file.exists()) {
            return url;
        }
        return null;
    }

    private URL findByClassloader(String resource) {
        return BIRTReportService.class.getResource(resource);
    }
}

