/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.impl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Locale;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.core.runtime.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sernet.verinice.interfaces.oda.IVeriniceOdaDriver;
import sernet.verinice.interfaces.report.IOutputFormat;
import sernet.verinice.interfaces.report.IReportOptions;
import sernet.verinice.interfaces.report.IReportType;
import sernet.verinice.interfaces.report.ReportTypeException;
import sernet.verinice.model.report.ReportTemplateMetaData;
import sernet.verinice.report.service.Activator;
import sernet.verinice.report.service.impl.BIRTReportService;
import sernet.verinice.report.service.impl.security.ReportSecurityManager;
import sernet.verinice.security.report.ReportSecurityContext;

public class GenericReportType
implements IReportType {
    private static final Logger LOG = LoggerFactory.getLogger(GenericReportType.class);
    private IReportOptions options;

    public String getId() {
        return "";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "";
    }

    public IOutputFormat[] getOutputFormats() {
        return null;
    }

    public void createReport(IReportOptions reportOptions) {
        this.options = reportOptions;
    }

    public String getReportFile() {
        return null;
    }

    public void setReportFile(String file) {
    }

    public String getUseCaseID() {
        return null;
    }

    public void createReport(ReportTemplateMetaData metadata) {
        BIRTReportService brs = new BIRTReportService();
        URL rptURL = null;
        try {
            if (metadata.isServer()) {
                rptURL = new URL(String.valueOf(GenericReportType.getDepositPath("report_templates_remote")) + metadata.getFilename());
            } else {
                IVeriniceOdaDriver odaDriver = Activator.getDefault().getOdaDriver();
                URI locationConst = URIUtil.fromString((String)odaDriver.getLocalReportLocation());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("determined value for \"locationConst\":\t" + locationConst);
                    LOG.debug("File to open:\t" + metadata.getFilename());
                }
                URI u = URIUtil.append((URI)locationConst, (String)metadata.getFilename());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("URI generated:\t" + u.toString());
                    LOG.debug("Unencoded URI:\t" + URIUtil.toUnencodedString((URI)u));
                    LOG.debug("Default Charset:\t" + Charset.defaultCharset().displayName(Locale.getDefault()));
                    LOG.debug("Default Locale:\t" + Locale.getDefault().getLanguage());
                }
                File f1 = new File(URIUtil.toUnencodedString((URI)u));
                rptURL = f1.toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            LOG.error("Error reading rptdesign", (Throwable)e);
            throw new ReportTypeException((Throwable)e);
        }
        catch (URISyntaxException e) {
            LOG.error("Unable to parse URL of template location", (Throwable)e);
            throw new ReportTypeException((Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Trying to open report from template at:\t" + rptURL.toString());
        }
        ReportSecurityContext reportSecurityContext = new ReportSecurityContext(this.options, rptURL, brs.getLogfile(), metadata);
        ReportSecurityManager secureReportExecutionManager = new ReportSecurityManager(reportSecurityContext);
        IRunAndRenderTask task = brs.createTask(reportSecurityContext.getRptDesignUrl(), this.options);
        task = brs.prepareTaskForRendering(task, this.options);
        brs.performRenderTask(task, secureReportExecutionManager);
    }

    public static String getDepositPath(String locationConstant) {
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("osgi.instance.area"));
        if (!sb.toString().endsWith(String.valueOf(File.separatorChar))) {
            sb.append(File.separatorChar);
        }
        sb.append(locationConstant);
        if (!sb.toString().endsWith(String.valueOf(File.separatorChar))) {
            sb.append(File.separatorChar);
        }
        return sb.toString();
    }
}

