/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.impl;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDataExtractionOption;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IExtractionOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IResultSetItem;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.elements.SimpleMasterPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sernet.gs.ui.rcp.main.ServiceComponent;
import sernet.verinice.interfaces.oda.IVeriniceOdaDriver;
import sernet.verinice.interfaces.report.IReportOptions;
import sernet.verinice.model.report.AbstractOutputFormat;
import sernet.verinice.report.service.Activator;
import sernet.verinice.report.service.impl.ReportResourceLocator;
import sernet.verinice.report.service.impl.security.ReportExecutionThread;
import sernet.verinice.report.service.impl.security.ReportSecurityManager;
import sernet.verinice.security.report.ReportClassLoader;

public class BIRTReportService {
    final Logger log = LoggerFactory.getLogger(BIRTReportService.class);
    private IReportEngine engine;
    private IReportRunnable design;
    private IResourceLocator resourceLocator;
    private static final String COULD_NOT_OPEN_DESIGN_ERR = "Could not open report design: ";
    private static final int MILLIS_PER_SECOND = 1000;
    private ReportClassLoader secureClassLoader = new ReportClassLoader(this.getClass().getClassLoader());

    public BIRTReportService() {
        int logMaxBackupIndex = 10;
        int logRollingSize = 3000000;
        EngineConfig config = new EngineConfig();
        this.resourceLocator = new ReportResourceLocator();
        IVeriniceOdaDriver odaDriver = Activator.getDefault().getOdaDriver();
        boolean useReportLogging = odaDriver.getReportLoggingState();
        HashMap hm = config.getAppContext();
        if (odaDriver.isSandboxEnabled()) {
            hm.put("PARENT_CLASSLOADER", this.secureClassLoader);
        } else {
            hm.put("PARENT_CLASSLOADER", BIRTReportService.class.getClassLoader());
        }
        config.setAppContext(hm);
        if (useReportLogging) {
            String pref = odaDriver.getLogFile();
            String logDir = pref.substring(0, pref.lastIndexOf(File.separator));
            String logFile = pref.substring(pref.lastIndexOf(File.separator) + 1);
            config.setLogConfig(logDir, Level.parse(odaDriver.getLogLvl()));
            config.setLogFile(logFile);
            config.setLogMaxBackupIndex(10);
            config.setLogRollingSize(3000000);
            if (this.log.isDebugEnabled()) {
                this.log.debug("LogParameter:\t\tLogFile:\t" + logFile + "\tLogDir:\t" + logDir + "\tLogLvl:\t" + odaDriver.getLogLvl());
            }
        }
        IReportEngineFactory factory = (IReportEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
        this.engine = factory.createReportEngine(config);
    }

    public IRunAndRenderTask createTask(URL rptDesignURL, IReportOptions options) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("DesignURL:\t" + rptDesignURL);
            this.log.debug("Locale:\t" + Locale.getDefault().toString());
        }
        HashMap<String, IResourceLocator> map = new HashMap<String, IResourceLocator>();
        map.put("resourceLocator", this.resourceLocator);
        IRunAndRenderTask task = null;
        try {
            this.design = this.engine.openReportDesign(null, rptDesignURL.openStream(), map);
            ReportDesignHandle designHandle = (ReportDesignHandle)this.design.getDesignHandle();
            if (StringUtils.isNotBlank((String)options.getClassificationHint())) {
                this.addClassificationHeader(designHandle);
            }
            task = this.engine.createRunAndRenderTask(this.design);
        }
        catch (EngineException e) {
            this.log.error(COULD_NOT_OPEN_DESIGN_ERR, (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            this.log.error(COULD_NOT_OPEN_DESIGN_ERR, (Throwable)e);
            throw new IllegalStateException(e);
        }
        task.setLocale(Locale.getDefault());
        return task;
    }

    private void addClassificationHeader(ReportDesignHandle designHandle) {
        ElementFactory elementFactory = designHandle.getElementFactory();
        try {
            SlotHandle masterPages = designHandle.getMasterPages();
            List contents = masterPages.getContents();
            if (contents.size() != 1) {
                this.log.info("not only one slot in master pages");
                return;
            }
            TextDataHandle newTextData = elementFactory.newTextData("classification");
            newTextData.setHeight("15pt");
            newTextData.setWidth("100%");
            newTextData.setContentType("plain");
            newTextData.setName("classificationHint");
            newTextData.setValueExpr("reportContext.getAppContext().get(\"classification_hint\")");
            newTextData.setProperty("textAlign", (Object)"center");
            newTextData.setProperty("fontSize", (Object)"12pt");
            SimpleMasterPageHandle designElementHandle = (SimpleMasterPageHandle)contents.get(0);
            SimpleMasterPage masterPage = (SimpleMasterPage)designElementHandle.getElement();
            masterPage.add(newTextData.getElement(), 0);
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
    }

    public IDataExtractionTask createExtractionTask(URL rptDesignURL) {
        File f;
        if (this.log.isDebugEnabled()) {
            this.log.debug("ReportDesignURL:\t" + rptDesignURL.toString());
        }
        HashMap<String, IResourceLocator> map = new HashMap<String, IResourceLocator>();
        map.put("resourceLocator", this.resourceLocator);
        IRunTask task = null;
        try {
            IReportRunnable design0 = this.engine.openReportDesign(null, rptDesignURL.openStream(), map);
            task = this.engine.createRunTask(design0);
        }
        catch (EngineException e) {
            this.log.error(COULD_NOT_OPEN_DESIGN_ERR, (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            this.log.error(COULD_NOT_OPEN_DESIGN_ERR, (Throwable)e);
            throw new IllegalStateException(e);
        }
        task.getAppContext().put("PARENT_CLASSLOADER", BIRTReportService.class.getClassLoader());
        try {
            f = File.createTempFile("verinice", ".rptdocument");
        }
        catch (IOException e) {
            this.log.error("Could not create temporary file for report document.");
            throw new IllegalStateException(e);
        }
        try {
            task.run(f.getAbsolutePath());
        }
        catch (EngineException e) {
            this.log.error("Could not create report: ", (Throwable)e);
            throw new IllegalStateException(e);
        }
        task.close();
        IReportDocument document = null;
        try {
            document = this.engine.openReportDocument(f.getAbsolutePath());
        }
        catch (EngineException e) {
            this.log.error("Could not open report document: ", (Throwable)e);
            throw new IllegalStateException(e);
        }
        return this.engine.createDataExtractionTask(document);
    }

    public void extract(IDataExtractionTask task, IReportOptions options, int resultSetIndex) {
        List resultSetList;
        IDataExtractionOption extractionOptions = (IDataExtractionOption)((AbstractOutputFormat)options.getOutputFormat()).createBIRTExtractionOptions();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (OutputStream os = Files.newOutputStream(options.getOutputFile().toPath(), new OpenOption[0]);){
                extractionOptions.setOutputStream(os);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.error("Could not prepare output stream: ", (Throwable)e);
            throw new IllegalStateException(e);
        }
        try {
            resultSetList = task.getResultSetList();
        }
        catch (EngineException e) {
            this.log.error("Could not prepare extraction: ", (Throwable)e);
            throw new IllegalStateException(e);
        }
        IResultSetItem resultItem = (IResultSetItem)resultSetList.get(resultSetIndex);
        task.selectResultSet(resultItem.getResultSetName());
        try {
            task.extract((IExtractionOption)extractionOptions);
        }
        catch (EngineException e) {
            this.log.error("Could not extract data: ", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (BirtException e) {
            this.log.error("Could not extract data: ", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private void destroyEngine() {
        if (this.engine != null) {
            this.engine.destroy();
        }
    }

    public IRunAndRenderTask prepareTaskForRendering(IRunAndRenderTask task, IReportOptions options) {
        task.getAppContext().put("classification_hint", options.getClassificationHint());
        IRenderOption renderOptions = (IRenderOption)ServiceComponent.getDefault().getReportService().getRenderOptions(options.getOutputFormat().getId());
        renderOptions.setOutputFileName(options.getOutputFile().getAbsolutePath());
        if (options.getRootElement() != null) {
            task.getAppContext().put("rootElementId", options.getRootElement());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Root-Element:\t" + options.getRootElement());
            }
        } else if (options.getRootElements() != null && options.getRootElements().length > 0) {
            task.getAppContext().put("rootElementIds", options.getRootElements());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Root-Elements: " + Arrays.toString((Object[])options.getRootElements()));
            }
        }
        task.setRenderOption(renderOptions);
        return task;
    }

    public void performRenderTask(IRunAndRenderTask task, ReportSecurityManager secureReportExecutionManager) {
        try {
            long startTime = System.currentTimeMillis();
            this.preloadClasses();
            IVeriniceOdaDriver odaDriver = Activator.getDefault().getOdaDriver();
            ReportExecutionThread reportExecutionThread = new ReportExecutionThread(task, secureReportExecutionManager, odaDriver.isSandboxEnabled());
            if (odaDriver.isSandboxEnabled()) {
                reportExecutionThread.setContextClassLoader((ClassLoader)this.secureClassLoader);
            }
            reportExecutionThread.run();
            if (this.log.isDebugEnabled()) {
                long duration = (System.currentTimeMillis() - startTime) / 1000L;
                this.log.debug("RunAndRenderTask lasts " + duration + " seconds");
            }
        }
        finally {
            this.destroyEngine();
        }
    }

    public void preloadClasses() {
        try {
            DataTypeUtil.toOdiTypeClass((int)1);
        }
        catch (BirtException e) {
            this.log.error("Error while preloading class DataTypeUtil", (Throwable)e);
        }
    }

    public String getLogfile() {
        return Activator.getDefault().getOdaDriver().getLogFile();
    }
}

