/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.GraphCommand;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.interfaces.graph.GraphElementLoader;
import sernet.verinice.interfaces.graph.IGraphElementLoader;
import sernet.verinice.interfaces.graph.VeriniceGraph;
import sernet.verinice.model.common.CnATreeElement;

public class AssetSzenarioDatamodel
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(AssetSzenarioDatamodel.class);
    private static final String[] TYPE_IDS = new String[]{"asset", "incident_scenario"};
    private ICommandService commandService;
    private Integer scopeId;
    private List<CnATreeElement> assetList;
    private Map<Integer, List<CnATreeElement>> scenarioMap;

    public void init() {
        try {
            this.doInit();
        }
        catch (Exception e) {
            LOG.error("Error while creating data model", (Throwable)e);
        }
    }

    private void doInit() throws CommandException {
        GraphCommand command = new GraphCommand();
        GraphElementLoader loader = new GraphElementLoader();
        loader.setScopeId(this.getScopeId());
        loader.setTypeIds(TYPE_IDS);
        command.addLoader((IGraphElementLoader)loader);
        command.addRelationId("rel_incscen_asset");
        command = (GraphCommand)this.getCommandService().executeCommand((ICommand)command);
        VeriniceGraph graph = command.getGraph();
        this.assetList = new ArrayList<CnATreeElement>(graph.getElements("asset"));
        this.scenarioMap = new Hashtable<Integer, List<CnATreeElement>>();
        for (CnATreeElement asset : this.assetList) {
            ArrayList scenarioList = new ArrayList(graph.getLinkTargets(asset, "rel_incscen_asset"));
            this.scenarioMap.put(asset.getDbId(), scenarioList);
        }
    }

    public List<CnATreeElement> getAssets() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAssets()...");
        }
        return this.assetList;
    }

    public List<CnATreeElement> getScenarios(Integer assetId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getScenarios for asset-id: " + assetId);
        }
        return this.scenarioMap.get(assetId);
    }

    public ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = ServiceFactory.lookupCommandService();
        }
        return this.commandService;
    }

    public Integer getScopeId() {
        return this.scopeId;
    }

    public void setScopeId(Integer scopeId) {
        this.scopeId = scopeId;
    }
}

