/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.commands;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.GenericCommand;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.ControlGroup;
import sernet.verinice.model.samt.SamtTopic;
import sernet.verinice.report.service.commands.LoadChapterListCommand;
import sernet.verinice.service.commands.crud.LoadCnAElementById;

public class LoadWorstFindingsCommand
extends GenericCommand {
    private Object[][] result;
    private int id;
    private static final Logger log = LoggerFactory.getLogger(LoadWorstFindingsCommand.class);
    public static final String SAMT_PROP_FINDING = "samt_topic_audit_findings";
    public static final String SAMT_PROP_MEASURE = "samt_topic_controlnote";
    private transient CacheManager manager = null;
    private String cacheId = null;
    private transient Cache cache = null;

    public LoadWorstFindingsCommand(int id) {
        int id0 = -1;
        if (String.valueOf(id).startsWith(String.valueOf(LoadChapterListCommand.PLACEHOLDER_CONTROLGROUP_ID))) {
            String chapterIdString = String.valueOf(id);
            chapterIdString = chapterIdString.substring(String.valueOf(LoadChapterListCommand.PLACEHOLDER_CONTROLGROUP_ID).length());
            id0 = Integer.parseInt(chapterIdString);
        }
        this.id = id0 > -1 ? id0 : id;
    }

    public Object[][] getResult() {
        return this.result != null ? (Object[][])this.result.clone() : null;
    }

    private Set<SamtTopic> getAllSamtTopicChildren(ControlGroup parent) {
        HashSet<SamtTopic> set = new HashSet();
        if (this.getCache().get((Serializable)((Object)parent.getUuid())) != null) {
            set = (Set)((Object)this.getCache().get((Serializable)((Object)parent.getUuid())).getValue());
        } else {
            for (CnATreeElement e : parent.getChildren()) {
                if (e instanceof ControlGroup) {
                    set.addAll(this.getAllSamtTopicChildren((ControlGroup)e));
                    continue;
                }
                if (!(e instanceof SamtTopic)) continue;
                set.add((SamtTopic)e);
            }
            this.getCache().put(new Element((Object)parent.getUuid(), set));
        }
        return set;
    }

    public void execute() {
        int maxDevStart = -2;
        int maxRiskStart = -2;
        int defaultResultSize = 6;
        ControlGroup group = null;
        if (this.getCache().get((Serializable)Integer.valueOf(this.id)) != null) {
            group = (ControlGroup)this.getCache().get((Serializable)Integer.valueOf(this.id)).getValue();
        } else {
            try {
                LoadCnAElementById command = new LoadCnAElementById("controlgroup", this.id);
                command = (LoadCnAElementById)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                group = (ControlGroup)command.getFound();
                this.getCache().put(new Element((Serializable)Integer.valueOf(this.id), (Serializable)group));
            }
            catch (CommandException e) {
                log.error("Error while executing command", (Throwable)e);
            }
        }
        int maxDev = -2;
        int maxRisk = -2;
        ArrayList<SamtTopic> worstTopics = new ArrayList<SamtTopic>();
        Set<SamtTopic> allSamtTopics = this.getAllSamtTopicChildren(group);
        for (SamtTopic topic : allSamtTopics) {
            int curRisk = topic.getNumericProperty("samt_topic_audit_ra");
            if (curRisk <= maxRisk) continue;
            maxRisk = curRisk;
        }
        for (SamtTopic topic : allSamtTopics) {
            if (topic.getNumericProperty("samt_topic_audit_ra") != maxRisk) continue;
            worstTopics.add(topic);
        }
        for (SamtTopic topic : worstTopics) {
            int curDev = topic.getNumericProperty("samt_topic_audit_devi");
            if (curDev <= maxDev) continue;
            maxDev = curDev;
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (SamtTopic worstTopic : worstTopics) {
            if (worstTopic.getNumericProperty("samt_topic_audit_devi") != maxDev) continue;
            String finding = worstTopic.getEntity().getValue(SAMT_PROP_FINDING);
            String measure = worstTopic.getEntity().getValue(SAMT_PROP_MEASURE);
            if (finding == null || finding.equals("")) continue;
            arrayList.add(new Object[]{worstTopic.getDbId(), worstTopic.getTitle(), finding, maxDev, maxRisk, measure});
        }
        this.result = (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][6]);
    }

    private Cache getCache() {
        this.cache = this.manager == null || Status.STATUS_SHUTDOWN.equals(this.manager.getStatus()) || this.cache == null || !Status.STATUS_ALIVE.equals(this.cache.getStatus()) ? this.createCache() : this.manager.getCache(this.cacheId);
        return this.cache;
    }

    private Cache createCache() {
        int maxElementsInMemory = 20000;
        int timeToLiveSeconds = 600;
        int timeToIdleSeconds = 500;
        this.cacheId = UUID.randomUUID().toString();
        this.manager = CacheManager.create();
        this.cache = new Cache(this.cacheId, 20000, false, false, 600L, 500L);
        this.manager.addCache(this.cache);
        return this.cache;
    }
}

