/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.commands;

import java.util.ArrayList;
import java.util.List;
import sernet.verinice.interfaces.GenericCommand;
import sernet.verinice.interfaces.ICachedCommand;
import sernet.verinice.model.common.CnATreeElement;

public class LoadReportParentOrgForObject
extends GenericCommand
implements ICachedCommand {
    private CnATreeElement child;
    private CnATreeElement org;
    private boolean resultInjectedFromCache = false;

    public LoadReportParentOrgForObject(CnATreeElement child) {
        this.child = child;
    }

    public void execute() {
        if (!this.resultInjectedFromCache) {
            this.org = this.child.isOrganization() ? this.child : this.findOrg(this.child);
        }
    }

    private CnATreeElement findOrg(CnATreeElement cnATreeElement) {
        CnATreeElement parent = cnATreeElement.getParent();
        if (parent == null) {
            return null;
        }
        if (parent.isOrganization()) {
            return parent;
        }
        return this.findOrg(parent);
    }

    public CnATreeElement getOrg() {
        return this.org;
    }

    public List<CnATreeElement> getElements() {
        ArrayList<CnATreeElement> result = new ArrayList<CnATreeElement>();
        result.add(this.org);
        return result;
    }

    public String getCacheID() {
        StringBuilder cacheID = new StringBuilder();
        cacheID.append(((Object)((Object)this)).getClass().getSimpleName());
        cacheID.append(this.child.getUuid());
        return cacheID.toString();
    }

    public void injectCacheResult(Object result) {
        this.org = (CnATreeElement)result;
        this.resultInjectedFromCache = true;
    }

    public Object getCacheableResult() {
        return this.org;
    }
}

