/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.commands;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sernet.gs.service.NumericStringComparator;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.GenericCommand;
import sernet.verinice.interfaces.ICachedCommand;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.ControlGroup;
import sernet.verinice.model.samt.SamtTopic;
import sernet.verinice.service.commands.crud.LoadChildrenForExpansion;
import sernet.verinice.service.commands.crud.LoadReportElements;

public class LoadISAReportChapterList
extends GenericCommand
implements ICachedCommand {
    private static final Logger log = LoggerFactory.getLogger(LoadISAReportChapterList.class);
    public static final String[] COLUMNS = new String[]{"dbid", "title"};
    private static final String OVERVIEW_PROPERTY = "controlgroup_is_NoIso_group";
    private static final int OVERVIEW_PROPERTY_TARGET = 0;
    private transient CacheManager manager = null;
    private String cacheId = null;
    private transient Cache cache = null;
    private Integer rootElmt;
    private List<List<String>> result = new ArrayList<List<String>>(0);
    private boolean resultInjectedFromCache = false;

    public LoadISAReportChapterList(Integer root) {
        this.rootElmt = root;
    }

    public void execute() {
        if (!this.resultInjectedFromCache) {
            for (ControlGroup g : this.getControlGroups(this.rootElmt)) {
                this.result.add(this.createValueEntry((CnATreeElement)g));
            }
        }
    }

    private List<ControlGroup> getControlGroups(Integer root) {
        ArrayList<ControlGroup> retList = new ArrayList<ControlGroup>(0);
        HashSet<ControlGroup> alreadySeen = new HashSet<ControlGroup>(0);
        try {
            LoadReportElements command = new LoadReportElements("controlgroup", root, true);
            command = (LoadReportElements)this.getCommandService().executeCommand((ICommand)command);
            List groups = command.getElements();
            if (groups.size() == 1 && ((CnATreeElement)groups.get(0)).getDbId().equals(root)) {
                groups.clear();
                groups.addAll(command.getElements("controlgroup", (CnATreeElement)groups.get(0)));
            }
            for (CnATreeElement e : groups) {
                ControlGroup c;
                if (!(e instanceof ControlGroup) || alreadySeen.contains(c = (ControlGroup)e)) continue;
                alreadySeen.add(c);
                if (!(e.getParent() instanceof ControlGroup) || !c.getEntity().getPropertyValue(OVERVIEW_PROPERTY).equals(String.valueOf(0)) || !this.containsSamtTopicsOnly(c)) continue;
                retList.add(c);
            }
        }
        catch (CommandException e) {
            log.error("Error while determing controlgroups");
        }
        retList.trimToSize();
        Collections.sort(retList, new Comparator<ControlGroup>(){

            @Override
            public int compare(ControlGroup o1, ControlGroup o2) {
                NumericStringComparator comp = new NumericStringComparator();
                return comp.compare((Object)o1.getTitle(), (Object)o2.getTitle());
            }
        });
        return retList;
    }

    private boolean containsSamtTopicsOnly(ControlGroup group) {
        if (group.getChildren().size() == 0) {
            return false;
        }
        for (CnATreeElement child : group.getChildren()) {
            if (child instanceof SamtTopic) continue;
            return false;
        }
        return true;
    }

    private List<String> createValueEntry(CnATreeElement elmt) {
        if (!elmt.isChildrenLoaded() && elmt.getDbId() > 0) {
            elmt = this.loadChildren(elmt);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(String.valueOf(elmt.getDbId()));
        list.add(elmt.getTitle());
        return list;
    }

    private CnATreeElement loadChildren(CnATreeElement el) {
        if (el.isChildrenLoaded()) {
            return el;
        }
        if (this.getCache().get((Serializable)((Object)el.getUuid())) != null) {
            return (CnATreeElement)this.getCache().get((Serializable)((Object)el.getUuid())).getValue();
        }
        LoadChildrenForExpansion command = new LoadChildrenForExpansion(el);
        try {
            command = (LoadChildrenForExpansion)this.getCommandService().executeCommand((ICommand)command);
            CnATreeElement newElement = command.getElementWithChildren();
            newElement.setChildrenLoaded(true);
            this.getCache().put(new Element((Serializable)((Object)el.getUuid()), (Serializable)newElement));
            return newElement;
        }
        catch (CommandException e) {
            log.error("error while loading children of CnaTreeElment", (Throwable)e);
            return null;
        }
    }

    private Cache getCache() {
        this.cache = this.manager == null || Status.STATUS_SHUTDOWN.equals(this.manager.getStatus()) || this.cache == null || !Status.STATUS_ALIVE.equals(this.cache.getStatus()) ? this.createCache() : this.manager.getCache(this.cacheId);
        return this.cache;
    }

    private Cache createCache() {
        int maxElementsInMemory = 20000;
        int timeToLiveSeconds = 600;
        int timeToIdleSeconds = 500;
        this.cacheId = UUID.randomUUID().toString();
        this.manager = CacheManager.create();
        this.cache = new Cache(this.cacheId, 20000, false, false, 600L, 500L);
        this.manager.addCache(this.cache);
        return this.cache;
    }

    public List<List<String>> getResult() {
        return this.result;
    }

    public String getCacheID() {
        StringBuilder cacheID = new StringBuilder();
        cacheID.append(((Object)((Object)this)).getClass().getSimpleName());
        cacheID.append(String.valueOf(this.rootElmt));
        return cacheID.toString();
    }

    public void injectCacheResult(Object result) {
        this.result = (ArrayList)result;
        this.resultInjectedFromCache = true;
        if (log.isDebugEnabled()) {
            log.debug("Result in " + ((Object)((Object)this)).getClass().getCanonicalName() + " injected from cache");
        }
    }

    public Object getCacheableResult() {
        return this.result;
    }
}

