/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.commands;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.GenericCommand;
import sernet.verinice.interfaces.ICachedCommand;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.ControlGroup;
import sernet.verinice.model.iso27k.IControl;
import sernet.verinice.model.samt.SamtTopic;
import sernet.verinice.service.commands.crud.LoadReportElements;

public class LoadISAQuestionRadarChartData
extends GenericCommand
implements ICachedCommand {
    private static final Logger log = LoggerFactory.getLogger(LoadISAQuestionRadarChartData.class);
    private static final int THRESHOLD_VALUE = 3;
    public static final String[] COLUMNS = new String[]{"title", "riskValue", "threshold"};
    private static final int MINIMUM_CHART_ENTRIES = 7;
    private Integer rootElmnt;
    private List<List<String>> result;
    private boolean resultInjectedFromCache = false;

    public LoadISAQuestionRadarChartData(Integer root) {
        this.rootElmnt = root;
        this.result = new ArrayList<List<String>>(0);
    }

    public LoadISAQuestionRadarChartData(String root) {
        this(Integer.parseInt(root));
    }

    public void execute() {
        if (!this.resultInjectedFromCache) {
            try {
                LoadReportElements command = new LoadReportElements("samt_topic", this.rootElmnt, true);
                command = (LoadReportElements)this.getCommandService().executeCommand((ICommand)command);
                List elements = command.getElements();
                for (CnATreeElement e : elements) {
                    if (!(e instanceof SamtTopic)) continue;
                    SamtTopic topic = (SamtTopic)e;
                    ArrayList<String> list = new ArrayList<String>(0);
                    int maturity = this.getMaturity((IControl)topic);
                    String title = this.adjustTitle(topic.getTitle(), maturity);
                    list.add(title);
                    list.add(String.valueOf(maturity));
                    list.add(String.valueOf(3));
                    list.trimToSize();
                    this.result.add(list);
                }
            }
            catch (CommandException e) {
                log.error("Error while determing samt topics", (Throwable)e);
            }
        }
    }

    public List<List<String>> getResult() {
        if (this.result.size() < 7) {
            this.addPaddingValues();
        }
        return this.result;
    }

    public void addPaddingValues() {
        while (this.result.size() < 7) {
            ArrayList<String> paddingEntry = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.result.size()) {
                sb.append(" ");
                ++i;
            }
            paddingEntry.add(sb.toString());
            paddingEntry.add(String.valueOf(0));
            paddingEntry.add(String.valueOf(3));
            this.result.add(paddingEntry);
        }
    }

    public Integer getWeights(ControlGroup cg) {
        int weight = 0;
        for (CnATreeElement child : cg.getChildren()) {
            IControl control;
            if (child instanceof IControl) {
                control = (IControl)child;
                weight += control.getWeight2();
            }
            if (!(child instanceof ControlGroup)) continue;
            control = (ControlGroup)child;
            weight += this.getWeights((ControlGroup)control).intValue();
        }
        return weight;
    }

    public Integer getWeightedMaturity(IControl contr) {
        return this.getMaturity(contr) * contr.getWeight2();
    }

    public Double getMaturityByWeight(IControl contr) {
        return (double)this.getWeightedMaturity(contr).intValue() / (double)contr.getWeight2();
    }

    public int getMaturity(IControl control) {
        return control.getMaturity();
    }

    private String adjustTitle(String title, int maturity) {
        int maxTitleSize = 25;
        String retVal = null;
        if (maturity < 0) {
            maturity = 0;
        }
        String matString = String.valueOf(maturity);
        retVal = title.length() > 25 ? String.valueOf(title.substring(0, 25 - matString.length() - 3).trim()) + "... " : (title.length() + matString.length() > 25 ? String.valueOf(title.substring(0, title.length() - matString.length() - 3).trim()) + "... " : title);
        return String.valueOf(retVal) + "(" + matString + ")";
    }

    public String getCacheID() {
        StringBuilder cacheID = new StringBuilder();
        cacheID.append(((Object)((Object)this)).getClass().getSimpleName());
        cacheID.append(String.valueOf(this.rootElmnt));
        return cacheID.toString();
    }

    public void injectCacheResult(Object result) {
        this.result = (ArrayList)result;
        this.resultInjectedFromCache = true;
        if (log.isDebugEnabled()) {
            log.debug("Result in " + ((Object)((Object)this)).getClass().getCanonicalName() + " injected from cache");
        }
    }

    public Object getCacheableResult() {
        return this.result;
    }
}

