/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.commands;

import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Iterator;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.GenericCommand;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.bsi.Attachment;
import sernet.verinice.model.bsi.AttachmentFile;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.samt.SamtTopic;
import sernet.verinice.report.service.commands.LoadWorstFindingsCommand;
import sernet.verinice.service.commands.LoadAttachmentFile;
import sernet.verinice.service.commands.crud.LoadChildrenForExpansion;
import sernet.verinice.service.commands.crud.LoadCnAElementById;

public class LoadElementImagesCommand
extends GenericCommand {
    private int id;
    private int imageNr;
    private static final Logger log = LoggerFactory.getLogger(LoadElementImagesCommand.class);
    private byte[] result;
    private transient CacheManager manager = null;
    private String cacheId = null;
    private transient Cache cache = null;
    private static final int MAX_IMAGE_HEIGHT = 151;
    private static final int MAX_IMAGE_WIDTH = 310;

    public LoadElementImagesCommand() {
    }

    public LoadElementImagesCommand(int id) {
        this.id = id;
    }

    public LoadElementImagesCommand(int id, int imageNr) {
        this(id);
        this.imageNr = imageNr;
    }

    public byte[] getResult() {
        return this.result != null ? (byte[])this.result.clone() : null;
    }

    private boolean isImage(Attachment attachment) {
        boolean isImage = Boolean.FALSE;
        String[] stringArray = Attachment.getImageMimeTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String imageMimeType = stringArray[n2];
            if (attachment.getMimeType().equals(imageMimeType)) {
                isImage = Boolean.TRUE;
                break;
            }
            ++n2;
        }
        return isImage;
    }

    private Attachment getNthImage(SamtTopic topic, int n) {
        int i = 0;
        while (i < topic.getFiles().size()) {
            Iterator iter = topic.getFiles().iterator();
            int count = 0;
            while (iter.hasNext()) {
                Attachment a = (Attachment)iter.next();
                if (!this.isImage(a) || ++count != n) continue;
                return a;
            }
            ++i;
        }
        return null;
    }

    public void execute() {
        SamtTopic topic = null;
        try {
            Attachment attachment;
            LoadWorstFindingsCommand command = new LoadWorstFindingsCommand(this.id);
            command = (LoadWorstFindingsCommand)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            Object[][] wfResult = command.getResult();
            if (wfResult != null && wfResult.length > 0 && wfResult[0].length > 0) {
                int topicId = (Integer)wfResult[0][0];
                LoadCnAElementById command2 = new LoadCnAElementById("samt_topic", topicId);
                command2 = (LoadCnAElementById)ServiceFactory.lookupCommandService().executeCommand((ICommand)command2);
                topic = (SamtTopic)command2.getFound();
                if (!topic.isChildrenLoaded()) {
                    topic = (SamtTopic)this.loadChildren((CnATreeElement)topic);
                }
            }
            if (topic != null && topic.getFiles() != null && topic.getFiles().size() > 0 && (attachment = this.getNthImage(topic, this.imageNr)) != null) {
                LoadAttachmentFile command1 = new LoadAttachmentFile(attachment.getDbId());
                command1 = (LoadAttachmentFile)this.getCommandService().executeCommand((ICommand)command1);
                AttachmentFile attachmentFile = command1.getAttachmentFile();
                if (attachmentFile != null) {
                    this.result = this.processImageData(attachmentFile);
                }
            }
            if (this.result == null) {
                this.setDummyImage();
            }
        }
        catch (CommandException e) {
            log.error("Error while executing command", (Throwable)e);
        }
        catch (IOException e) {
            log.error("Error reading image from byte data", (Throwable)e);
        }
    }

    private byte[] processImageData(AttachmentFile attachmentFile) throws IOException {
        int degrees90 = 90;
        int defaultByteArraySize = 1000;
        ByteArrayInputStream in = new ByteArrayInputStream(attachmentFile.getFileData());
        BufferedImage bImage = ImageIO.read(in);
        ByteArrayOutputStream baos = null;
        BufferedImage rotatedImage = null;
        if (bImage.getHeight() > bImage.getWidth()) {
            rotatedImage = this.rotateImage(bImage, 90);
        }
        BufferedImage imageToWorkWith = null;
        imageToWorkWith = rotatedImage != null ? rotatedImage : bImage;
        if (imageToWorkWith.getWidth() > 310 || imageToWorkWith.getHeight() > 151) {
            Image image = imageToWorkWith.getScaledInstance(310, 151, 1);
            baos = new ByteArrayOutputStream(1000);
            if (image instanceof BufferedImage) {
                imageToWorkWith = (BufferedImage)image;
            } else {
                imageToWorkWith = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
                imageToWorkWith.getGraphics().drawImage(image, 0, 0, null);
            }
        }
        if (baos != null) {
            ImageIO.write((RenderedImage)imageToWorkWith, "jpeg", baos);
            return baos.toByteArray();
        }
        return attachmentFile.getFileData();
    }

    private void setDummyImage() {
        block13: {
            int defaultByteArraySize = 4096;
            URL url = ((Object)((Object)this)).getClass().getResource("onewhitepixel.jpg");
            InputStream is = null;
            ByteArrayOutputStream bais = new ByteArrayOutputStream();
            try {
                try {
                    is = url.openStream();
                    byte[] byteChunk = new byte[4096];
                    int i = 0;
                    while ((i = is.read(byteChunk)) > 0) {
                        bais.write(byteChunk, 0, i);
                    }
                    this.result = bais.toByteArray();
                }
                catch (IOException e) {
                    log.error("I-/O-Exception", (Throwable)e);
                    if (is == null) break block13;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        log.error("I-/O-Exception", (Throwable)e2);
                    }
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.error("I-/O-Exception", (Throwable)e);
                    }
                }
            }
        }
    }

    private BufferedImage rotateImage(BufferedImage image, int radiant) {
        AffineTransform transform = new AffineTransform();
        transform.rotate(Math.toRadians(radiant), (double)image.getWidth() / 2.0, (double)image.getHeight() / 2.0);
        AffineTransformOp op = new AffineTransformOp(transform, 2);
        return op.filter(image, null);
    }

    private Cache getCache() {
        this.cache = this.manager == null || Status.STATUS_SHUTDOWN.equals(this.manager.getStatus()) || this.cache == null || !Status.STATUS_ALIVE.equals(this.cache.getStatus()) ? this.createCache() : this.manager.getCache(this.cacheId);
        return this.cache;
    }

    private Cache createCache() {
        int maxElementsInMemory = 20000;
        int timeToLiveSeconds = 600;
        int timeToIdleSeconds = 500;
        this.cacheId = UUID.randomUUID().toString();
        this.manager = CacheManager.create();
        this.cache = new Cache(this.cacheId, 20000, false, false, 600L, 500L);
        this.manager.addCache(this.cache);
        return this.cache;
    }

    private CnATreeElement loadChildren(CnATreeElement el) {
        if (el.isChildrenLoaded()) {
            return el;
        }
        if (this.getCache().get((Serializable)el.getDbId()) != null) {
            return (CnATreeElement)this.getCache().get((Serializable)el.getDbId()).getValue();
        }
        LoadChildrenForExpansion command = new LoadChildrenForExpansion(el);
        try {
            command = (LoadChildrenForExpansion)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            CnATreeElement newElement = command.getElementWithChildren();
            newElement.setChildrenLoaded(true);
            this.getCache().put(new Element((Serializable)el.getDbId(), (Serializable)newElement));
            return newElement;
        }
        catch (CommandException e) {
            log.error("error while loading children of CnaTreeElment", (Throwable)e);
            return null;
        }
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setImageNr(int imageNr) {
        this.imageNr = imageNr;
    }
}

