/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.commands;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.GenericCommand;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.Audit;
import sernet.verinice.model.iso27k.ControlGroup;
import sernet.verinice.model.samt.SamtTopic;
import sernet.verinice.report.service.commands.LoadChapterListCommand;
import sernet.verinice.service.commands.crud.ComprehensiveSamtReportMatrix;
import sernet.verinice.service.commands.crud.LoadChildrenForExpansion;
import sernet.verinice.service.commands.crud.LoadCnAElementById;
import sernet.verinice.service.commands.crud.LoadReportElements;

public class LoadDeviationRiskTableCommand
extends GenericCommand {
    public static final String CONTROL_DEVIATION_PROPERTY = "control_isa_audit_devi";
    public static final String CONTROL_RISK_PROPERTY = "control_isa_audit_ra";
    public static final String SAMT_DEVIATION_PROPERTY = "samt_topic_audit_devi";
    public static final String SAMT_RISK_PROPERTY = "samt_topic_audit_ra";
    private static final String OVERVIEW_PROPERTY = "controlgroup_is_NoIso_group";
    private List<List<String>> result;
    private Integer chapterId;
    private String chapterName;
    private int rootObjectId;
    private boolean isNonIsoGroup = false;
    private transient CacheManager manager = null;
    private String cacheId = null;
    private transient Cache cache = null;
    private static final Logger log = LoggerFactory.getLogger(LoadDeviationRiskTableCommand.class);

    public LoadDeviationRiskTableCommand(int chapterId, String chapterName) {
        int chapterId0 = -1;
        if (String.valueOf(chapterId).startsWith(String.valueOf(LoadChapterListCommand.PLACEHOLDER_CONTROLGROUP_ID))) {
            String chapterIdString = String.valueOf(chapterId);
            chapterIdString = chapterIdString.substring(String.valueOf(LoadChapterListCommand.PLACEHOLDER_CONTROLGROUP_ID).length());
            chapterId0 = Integer.parseInt(chapterIdString);
            this.isNonIsoGroup = true;
        }
        this.chapterId = chapterId0 > -1 ? chapterId0 : chapterId;
        this.chapterName = chapterName;
    }

    public LoadDeviationRiskTableCommand(int chapterId, String chapterName, int rootObject) {
        this(chapterId, chapterName);
        this.rootObjectId = rootObject;
    }

    public List<List<String>> getResult() {
        return this.result;
    }

    private boolean isOverviewElement(ControlGroup group) {
        if (group.getEntity().getValue(OVERVIEW_PROPERTY) != null && !group.getEntity().getValue(OVERVIEW_PROPERTY).equals("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - void declaration
     */
    public void execute() {
        int matrixLines = 3;
        int matrixColumns = 4;
        Audit rootElement = null;
        ComprehensiveSamtReportMatrix chapterValues = new ComprehensiveSamtReportMatrix(3, 4);
        ArrayList<String> l = new ArrayList<String>();
        try {
            if (this.getCache().get((Serializable)Integer.valueOf(this.rootObjectId)) != null) {
                rootElement = (Audit)this.getCache().get((Serializable)Integer.valueOf(this.rootObjectId)).getValue();
            } else {
                LoadCnAElementById c1 = new LoadCnAElementById("audit", this.rootObjectId);
                c1 = (LoadCnAElementById)ServiceFactory.lookupCommandService().executeCommand((ICommand)c1);
                if (c1.getFound() instanceof Audit) {
                    rootElement = (Audit)c1.getFound();
                    this.getCache().put(new Element((Serializable)Integer.valueOf(this.rootObjectId), (Serializable)rootElement));
                }
            }
            String deviationProperty = "";
            String riskProperty = "";
            List<SamtTopic> cList = null;
            ControlGroup rootChapterElement = this.getRootChapter(this.chapterId);
            LoadReportElements command = null;
            if (this.chapterId == -1) {
                cList = new ArrayList(0);
                for (CnATreeElement cnATreeElement : this.getControlGroupChildren(rootChapterElement)) {
                    ControlGroup group;
                    if (!(cnATreeElement instanceof ControlGroup) || !this.isOverviewElement(group = (ControlGroup)cnATreeElement)) continue;
                    LoadReportElements c1 = new LoadReportElements("samt_topic", group.getDbId());
                    c1 = (LoadReportElements)ServiceFactory.lookupCommandService().executeCommand((ICommand)c1);
                    if (c1.getElements() == null || c1.getElements().size() <= 0) continue;
                    for (CnATreeElement e : c1.getElements()) {
                        cList.add((SamtTopic)e);
                    }
                }
            } else if (this.isNonIsoGroup) {
                command = new LoadReportElements("samt_topic", this.chapterId);
                command = (LoadReportElements)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                cList = command.getElements();
            } else if (rootElement != null && rootChapterElement != null) {
                if (this.getCache().get((Serializable)rootChapterElement.getDbId()) != null) {
                    cList = (List)this.getCache().get((Serializable)rootChapterElement.getDbId());
                } else if (this.getCache().get((Serializable)((Object)rootChapterElement.getUuid())) != null) {
                    cList = (List)((Object)this.getCache().get((Serializable)((Object)rootChapterElement.getUuid())).getValue());
                } else {
                    command = new LoadReportElements("samt_topic", rootChapterElement.getDbId());
                    command = (LoadReportElements)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                    cList = command.getElements();
                    this.getCache().put(new Element((Object)rootChapterElement.getUuid(), cList));
                }
            }
            deviationProperty = SAMT_DEVIATION_PROPERTY;
            riskProperty = SAMT_RISK_PROPERTY;
            if (cList != null) {
                for (CnATreeElement cnATreeElement : cList) {
                    int deviVal = cnATreeElement.getNumericProperty(deviationProperty);
                    int riskVal = cnATreeElement.getNumericProperty(riskProperty);
                    int deviField = -2;
                    int riskField = -2;
                    if (deviVal >= -1) {
                        deviField = deviVal + 1;
                    }
                    if (riskVal >= -1) {
                        riskField = riskVal + 1;
                    }
                    if (deviField <= -1 || riskField <= -1) continue;
                    chapterValues.increaseCount(Integer.valueOf(deviField), Integer.valueOf(riskField));
                }
            }
            if (rootChapterElement != null) {
                void var11_18;
                l.add(this.chapterName);
                boolean bl = false;
                while (var11_18 < 3) {
                    int column = 0;
                    while (column < 4) {
                        l.add(String.valueOf(chapterValues.getValue((int)var11_18, column)));
                        ++column;
                    }
                    ++var11_18;
                }
            }
        }
        catch (CommandException e) {
            log.error("Error while executing command", (Throwable)e);
        }
        this.result = new ArrayList<List<String>>();
        this.result.add(l);
    }

    private ControlGroup getRootChapter(int id) {
        if (id != -1 && id != -5) {
            LoadCnAElementById command = new LoadCnAElementById("controlgroup", id);
            try {
                command = (LoadCnAElementById)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                return (ControlGroup)command.getFound();
            }
            catch (CommandException e) {
                log.error("Error while executing command", (Throwable)e);
            }
        } else {
            ControlGroup rootControlgroup = null;
            switch (id) {
                case -1: {
                    LoadCnAElementById command = new LoadCnAElementById("audit", this.rootObjectId);
                    try {
                        command = (LoadCnAElementById)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                        for (CnATreeElement e : command.getFound().getChildren()) {
                            if (!(e instanceof ControlGroup)) continue;
                            rootControlgroup = (ControlGroup)e;
                        }
                    }
                    catch (CommandException e) {
                        log.error("Error while executing command", (Throwable)e);
                    }
                    break;
                }
            }
            return rootControlgroup;
        }
        return null;
    }

    private Cache getCache() {
        this.cache = this.manager == null || Status.STATUS_SHUTDOWN.equals(this.manager.getStatus()) || this.cache == null || !Status.STATUS_ALIVE.equals(this.cache.getStatus()) ? this.createCache() : this.manager.getCache(this.cacheId);
        return this.cache;
    }

    private Cache createCache() {
        int maxElementsInMemory = 20000;
        int timeToLiveSeconds = 600;
        int timeToIdleSeconds = 500;
        this.cacheId = UUID.randomUUID().toString();
        this.manager = CacheManager.create();
        this.cache = new Cache(this.cacheId, 20000, false, false, 600L, 500L);
        this.manager.addCache(this.cache);
        return this.cache;
    }

    private CnATreeElement loadChildren(CnATreeElement el) {
        if (el.isChildrenLoaded()) {
            return el;
        }
        if (this.getCache().get((Serializable)((Object)("childrenlist" + el.getUuid()))) != null) {
            return (CnATreeElement)this.getCache().get((Serializable)((Object)("childrenlist" + el.getUuid()))).getValue();
        }
        LoadChildrenForExpansion command = new LoadChildrenForExpansion(el);
        try {
            command = (LoadChildrenForExpansion)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            CnATreeElement newElement = command.getElementWithChildren();
            newElement.setChildrenLoaded(true);
            this.getCache().put(new Element((Serializable)((Object)("childrenlist" + el.getUuid())), (Serializable)newElement));
            return newElement;
        }
        catch (CommandException e) {
            log.error("error while loading children of CnaTreeElment", (Throwable)e);
            return null;
        }
    }

    private Set<ControlGroup> getControlGroupChildren(ControlGroup group) {
        HashSet<ControlGroup> set = new HashSet<ControlGroup>(0);
        if (!group.isChildrenLoaded()) {
            set.addAll(this.getControlGroupChildren((ControlGroup)this.loadChildren((CnATreeElement)group)));
        } else {
            for (CnATreeElement child : group.getChildren()) {
                if (!(child instanceof ControlGroup)) continue;
                set.add((ControlGroup)child);
                set.addAll(this.getControlGroupChildren((ControlGroup)child));
            }
        }
        return set;
    }
}

