/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.commands;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sernet.gs.service.NumericStringComparator;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.GenericCommand;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.Audit;
import sernet.verinice.model.iso27k.ControlGroup;
import sernet.verinice.service.commands.crud.LoadChildrenForExpansion;
import sernet.verinice.service.commands.crud.LoadCnAElementById;

public class LoadChapterListCommand
extends GenericCommand {
    private Object[][] result;
    private Integer chapterId;
    private CnATreeElement rootObject;
    private static final Logger log = LoggerFactory.getLogger(LoadChapterListCommand.class);
    private transient CacheManager manager = null;
    private String cacheId = null;
    private transient Cache cache = null;
    private static final String OVERVIEW_PROPERTY = "controlgroup_is_NoIso_group";
    public static final Integer PLACEHOLDER_CONTROLGROUP_ID = -7;
    private static final int OVERVIEW_PROPERTY_TARGET = 0;

    public LoadChapterListCommand(Integer chapterId) {
        this.chapterId = chapterId;
    }

    public LoadChapterListCommand(Integer chapterId, int rootId) {
        this(chapterId);
        this.setRootObject(rootId);
    }

    private void setRootObject(int id) {
        if (this.getCache().get((Serializable)Integer.valueOf(id)) != null) {
            this.rootObject = (Audit)this.getCache().get((Serializable)Integer.valueOf(id)).getValue();
            return;
        }
        LoadCnAElementById command = new LoadCnAElementById("audit", id);
        try {
            command = (LoadCnAElementById)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            CnATreeElement e = command.getFound();
            if (e instanceof Audit) {
                this.rootObject = this.loadChildren((CnATreeElement)((Audit)e));
            }
        }
        catch (Exception e) {
            log.error("Error while executing command", (Throwable)e);
        }
    }

    public Object[][] getResult() {
        return this.result != null ? (Object[][])this.result.clone() : null;
    }

    public void execute() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        list.addAll(this.computeChapters(this.chapterId));
        this.result = this.sortResults((Object[][])list.toArray((T[])new Object[list.size()][]));
    }

    private Object[][] sortResults(Object[][] unsortedResults) {
        if (unsortedResults.length > 0 && unsortedResults[0].length > 0) {
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            Object[][] objectArray = unsortedResults;
            int n = unsortedResults.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] objects = objectArray[n2];
                list.add(objects);
                ++n2;
            }
            Collections.sort(list, new Comparator<Object[]>(){

                @Override
                public int compare(Object[] o1, Object[] o2) {
                    if ((Integer)o1[0] > 0 && (Integer)o2[0] > 0) {
                        NumericStringComparator comparator = new NumericStringComparator();
                        return comparator.compare((Object)((String)o1[1]), (Object)((String)o2[1]));
                    }
                    if ((Integer)o1[0] < (Integer)o2[0]) {
                        return -1;
                    }
                    if ((Integer)o1[0] > (Integer)o2[0]) {
                        return 1;
                    }
                    return 0;
                }
            });
            return (Object[][])list.toArray((T[])new Object[unsortedResults.length][unsortedResults[0].length]);
        }
        return new Object[0][0];
    }

    private int getLvlCountToRootAudit(CnATreeElement elmt) {
        int count = 1;
        CnATreeElement parent = elmt.getParent();
        while (parent != null && !parent.equals((Object)this.rootObject)) {
            ++count;
            parent = parent.getParent();
        }
        return count;
    }

    /*
     * Unable to fully structure code
     */
    private List<Object[]> computeChapters(Integer id) {
        dummyDBID = -10;
        values = new ArrayList<Object[]>(0);
        if (!this.rootObject.isChildrenLoaded()) {
            this.loadChildren(this.rootObject);
        }
        if (id == -1) {
            for (CnATreeElement e : this.rootObject.getChildren()) {
                if (!(e instanceof ControlGroup)) continue;
                g = (ControlGroup)e;
                values.add(this.createValueEntry((CnATreeElement)g));
            }
        } else if (id == -2 || id == -3) {
            lvl1Groups = this.computeChapters(-1);
            g = lvl1Groups.iterator();
            if (g.hasNext()) {
                oArr = g.next();
                groupId = (Integer)oArr[0];
                g = null;
                if (this.getCache().get((Serializable)Integer.valueOf(groupId)) != null) {
                    g = (ControlGroup)this.getCache().get((Serializable)Integer.valueOf(groupId)).getValue();
                } else {
                    command = new LoadCnAElementById("controlgroup", groupId);
                    try {
                        command = (LoadCnAElementById)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                        if (command.getFound() != null) {
                            g = (ControlGroup)command.getFound();
                            this.getCache().put(new Element((Serializable)Integer.valueOf(groupId), (Serializable)g));
                        }
                    }
                    catch (CommandException e) {
                        LoadChapterListCommand.log.error("Error while executing command", (Throwable)e);
                    }
                }
                if (g != null && g.getChildren() != null) {
                    for (CnATreeElement e : g.getChildren()) {
                        if (!(e instanceof ControlGroup)) continue;
                        values.add(this.createValueEntry(e));
                    }
                }
            }
        } else if (id == -5) {
            headlineGroup = new ControlGroup();
            headlineGroup.setTitel(String.valueOf(this.rootObject.getTitle()) + " Overview");
            headlineGroup.setDbId(Integer.valueOf(-10));
            values.add(this.createValueEntry((CnATreeElement)headlineGroup));
            for (CnATreeElement e : this.rootObject.getChildren()) {
                if (!(e instanceof ControlGroup)) continue;
                if (!e.isChildrenLoaded()) {
                    e = this.loadChildren(e);
                }
                for (CnATreeElement elmt : e.getChildren()) {
                    if (!(elmt instanceof ControlGroup)) continue;
                    if (!elmt.isChildrenLoaded()) {
                        elmt = this.loadChildren(elmt);
                    }
                    if (this.isCnaTreeElementInList(values, elmt) || !(elmt instanceof ControlGroup) || (isOverviewElementString = (g = (ControlGroup)elmt).getEntity().getValue("controlgroup_is_NoIso_group")) == null || !isOverviewElementString.equals(String.valueOf(0))) continue;
                    values.add(this.createValueEntry(elmt));
                }
            }
        } else if (id == -10) {
            for (CnATreeElement e : this.rootObject.getChildren()) {
                if (!(e instanceof ControlGroup)) continue;
                if (!e.isChildrenLoaded()) {
                    e = this.loadChildren(e);
                }
                for (CnATreeElement elmt : e.getChildren()) {
                    if (!(elmt instanceof ControlGroup)) continue;
                    if (!elmt.isChildrenLoaded()) {
                        elmt = this.loadChildren(elmt);
                    }
                    if (this.isCnaTreeElementInList(values, elmt) || !(elmt instanceof ControlGroup) || (isOverviewElementString = (g = (ControlGroup)elmt).getEntity().getValue("controlgroup_is_NoIso_group")) == null || isOverviewElementString.equals(String.valueOf(0))) continue;
                    values.add(this.createValueEntry(elmt));
                }
            }
        } else {
            ce = null;
            if (this.getCache().get((Serializable)id) != null) {
                ce = (CnATreeElement)this.getCache().get((Serializable)id).getValue();
            } else if (id == -1) {
                id5Groups = this.computeChapters(-5);
                for (Object[] o : id5Groups) {
                    groupid = (Integer)o[0];
                    for (ControlGroup rootChild : this.loadAllControlgroupChildren(this.rootObject)) {
                        if (rootChild.getDbId() != groupid || !rootChild.getEntity().getValue("controlgroup_is_NoIso_group").equals(String.valueOf(0))) continue;
                        values.add(this.createValueEntry((CnATreeElement)rootChild));
                    }
                }
            } else {
                command1 = new LoadCnAElementById("controlgroup", id);
                try {
                    command1 = (LoadCnAElementById)ServiceFactory.lookupCommandService().executeCommand((ICommand)command1);
                    ce = command1.getFound();
                    if (ce == null) {
                        command1 = new LoadCnAElementById("samt_topic", id);
                        ce = command1.getFound();
                    }
                    if (ce == null) ** GOTO lbl103
                    this.getCache().put(new Element((Serializable)id, (Serializable)ce));
                }
                catch (CommandException e) {
                    LoadChapterListCommand.log.error("Error while executing command", (Throwable)e);
                }
            }
lbl103:
            // 5 sources

            if (ce != null) {
                placeHolderGroup = new ControlGroup();
                if (ce instanceof ControlGroup) {
                    g = (ControlGroup)ce;
                    if (g.getEntity().getValue("controlgroup_is_NoIso_group").equals(String.valueOf(0))) {
                        placeHolderIdString = String.valueOf(LoadChapterListCommand.PLACEHOLDER_CONTROLGROUP_ID.toString()) + g.getDbId();
                        placeHolderGroup.setDbId(Integer.valueOf(Integer.parseInt(placeHolderIdString)));
                        if (!g.isChildrenLoaded()) {
                            g = (ControlGroup)this.loadChildren((CnATreeElement)g);
                        }
                        placeHolderGroup.setChildren(g.getChildren());
                        placeHolderGroup.setTitel("");
                    }
                    if (this.getLvlCountToRootAudit((CnATreeElement)g) == 2) {
                        for (CnATreeElement elmt : g.getChildren()) {
                            if (!(elmt instanceof ControlGroup)) continue;
                            values.add(this.createValueEntry(elmt));
                        }
                    }
                }
                if (values.size() == 0 && ce instanceof ControlGroup) {
                    values.add(this.createValueEntry((CnATreeElement)placeHolderGroup));
                }
            }
        }
        return values;
    }

    private List<ControlGroup> loadAllControlgroupChildren(CnATreeElement elmt) {
        ArrayList list = new ArrayList();
        if (elmt.isChildrenLoaded()) {
            if (this.getCache().get((Serializable)((Object)("controlgroupchildren" + elmt.getDbId()))) != null) {
                list = (ArrayList)this.getCache().get((Serializable)((Object)("controlgroupchildren" + elmt.getDbId()))).getValue();
            } else {
                for (CnATreeElement child : elmt.getChildren()) {
                    if (!(child instanceof ControlGroup)) continue;
                    list.add((ControlGroup)child);
                    list.addAll(this.loadAllControlgroupChildren(child));
                }
                this.getCache().put(new Element((Serializable)((Object)("controlgroupchildren" + elmt.getDbId())), (Serializable)list));
            }
        } else {
            elmt = this.loadChildren(elmt);
            list.addAll(this.loadAllControlgroupChildren(elmt));
        }
        return list;
    }

    private Object[] createValueEntry(CnATreeElement elmt) {
        if (!elmt.isChildrenLoaded() && elmt.getDbId() > 0) {
            elmt = this.loadChildren(elmt);
        }
        return new Object[]{elmt.getDbId(), elmt.getTitle()};
    }

    private CnATreeElement loadChildren(CnATreeElement el) {
        if (el.isChildrenLoaded()) {
            return el;
        }
        if (this.getCache().get((Serializable)((Object)el.getUuid())) != null) {
            return (CnATreeElement)this.getCache().get((Serializable)((Object)el.getUuid())).getValue();
        }
        LoadChildrenForExpansion command = new LoadChildrenForExpansion(el);
        try {
            command = (LoadChildrenForExpansion)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            CnATreeElement newElement = command.getElementWithChildren();
            newElement.setChildrenLoaded(true);
            this.getCache().put(new Element((Serializable)((Object)el.getUuid()), (Serializable)newElement));
            return newElement;
        }
        catch (CommandException e) {
            log.error("error while loading children of CnaTreeElment", (Throwable)e);
            return null;
        }
    }

    private boolean isCnaTreeElementInList(List<Object[]> list, CnATreeElement elmtToTest) {
        boolean isInList = false;
        for (Object[] o : list) {
            if (((Integer)o[0]).intValue() != elmtToTest.getDbId().intValue()) continue;
            isInList = true;
            break;
        }
        return isInList;
    }

    private Cache getCache() {
        this.cache = this.manager == null || Status.STATUS_SHUTDOWN.equals(this.manager.getStatus()) || this.cache == null || !Status.STATUS_ALIVE.equals(this.cache.getStatus()) ? this.createCache() : this.manager.getCache(this.cacheId);
        return this.cache;
    }

    private Cache createCache() {
        int maxElementsInMemory = 20000;
        int timeToLiveSeconds = 600;
        int timeToIdleSeconds = 500;
        this.cacheId = UUID.randomUUID().toString();
        this.manager = CacheManager.create();
        this.cache = new Cache(this.cacheId, 20000, false, false, 600L, 500L);
        this.manager.addCache(this.cache);
        return this.cache;
    }
}

