/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.commands;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sernet.gs.service.NumericStringComparator;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.GenericCommand;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.ControlGroup;
import sernet.verinice.model.samt.SamtTopic;
import sernet.verinice.report.service.commands.LoadChapterListCommand;
import sernet.verinice.service.commands.crud.LoadCnAElementById;

public class LoadAllFindingsCommand
extends GenericCommand {
    private Object[][] result;
    private Integer id;
    private static final Logger log = LoggerFactory.getLogger(LoadAllFindingsCommand.class);
    private transient CacheManager manager = null;
    private String cacheId = null;
    private transient Cache cache = null;
    private static final String SAMT_PERSON_INCHARGE_PROPERTY = "rel_samttopic_person-iso_resp";
    public static final String SAMT_MEASURE_PROPERTY = "samt_topic_controlnote";
    private static Map<Integer, Object[][]> computedData = new HashMap<Integer, Object[][]>();

    public LoadAllFindingsCommand(int id) {
        int id0 = -1;
        if (String.valueOf(id).startsWith(String.valueOf(LoadChapterListCommand.PLACEHOLDER_CONTROLGROUP_ID))) {
            String chapterIdString = String.valueOf(id);
            chapterIdString = chapterIdString.substring(String.valueOf(LoadChapterListCommand.PLACEHOLDER_CONTROLGROUP_ID).length());
            id0 = Integer.parseInt(chapterIdString);
        }
        this.id = id0 > -1 ? id0 : id;
    }

    public Object[][] getResult() {
        return this.result != null ? (Object[][])this.result.clone() : null;
    }

    private Set<SamtTopic> getAllSamtTopicChildren(ControlGroup parent) {
        HashSet<SamtTopic> set = new HashSet();
        if (this.getCache().get((Serializable)((Object)parent.getUuid())) != null) {
            set = (Set)((Object)this.getCache().get((Serializable)((Object)parent.getUuid())).getValue());
        } else {
            for (CnATreeElement e : parent.getChildren()) {
                if (e instanceof ControlGroup) {
                    set.addAll(this.getAllSamtTopicChildren((ControlGroup)e));
                    continue;
                }
                if (!(e instanceof SamtTopic)) continue;
                set.add((SamtTopic)e);
            }
            this.getCache().put(new Element((Object)parent.getUuid(), set));
        }
        return set;
    }

    private Object[][] generateResultEntry(ControlGroup group) {
        int defaultResultSize = 8;
        Set<SamtTopic> allTopics = this.getAllSamtTopicChildren(group);
        Object[][] retVal = new Object[allTopics.size()][8];
        Iterator<SamtTopic> iter = allTopics.iterator();
        int count = 0;
        while (iter.hasNext()) {
            retVal[count] = this.generateSamtEntry(iter.next());
            ++count;
        }
        return retVal;
    }

    private Object[][] sortResult(Object[][] unsortedResults) {
        if (unsortedResults != null && unsortedResults.length > 0 && unsortedResults[0].length > 0) {
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            Object[][] objectArray = unsortedResults;
            int n = unsortedResults.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] objects = objectArray[n2];
                list.add(objects);
                ++n2;
            }
            Collections.sort(list, new Comparator<Object[]>(){

                @Override
                public int compare(Object[] o1, Object[] o2) {
                    NumericStringComparator comparator = new NumericStringComparator();
                    return comparator.compare((Object)((String)o1[1]), (Object)((String)o2[1]));
                }
            });
            return (Object[][])list.toArray((T[])new Object[unsortedResults.length][unsortedResults[0].length]);
        }
        return new Object[0][0];
    }

    private Object[] generateSamtEntry(SamtTopic topic) {
        String finding = topic.getEntity().getValue("samt_topic_audit_findings");
        int dev = topic.getNumericProperty("samt_topic_audit_devi");
        int risk = topic.getNumericProperty("samt_topic_audit_ra");
        String measure = topic.getEntity().getValue(SAMT_MEASURE_PROPERTY);
        String personInCharge = "";
        for (CnALink link : topic.getLinksDown()) {
            if (!link.getRelationId().equals(SAMT_PERSON_INCHARGE_PROPERTY)) continue;
            personInCharge = link.getDependency().getTitle();
            break;
        }
        return new Object[]{topic.getDbId(), topic.getTitle(), finding, topic.getMaturity(), dev, risk, measure, personInCharge};
    }

    public void execute() {
        LoadCnAElementById command = new LoadCnAElementById("controlgroup", this.id);
        try {
            command = (LoadCnAElementById)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            if (command.getFound() != null) {
                computedData.put(this.id, this.generateResultEntry((ControlGroup)command.getFound()));
            }
        }
        catch (CommandException e) {
            log.error("Error while executing command", (Throwable)e);
        }
        this.result = computedData.get(this.id);
        this.result = this.sortResult(this.result);
    }

    private Cache getCache() {
        this.cache = this.manager == null || Status.STATUS_SHUTDOWN.equals(this.manager.getStatus()) || this.cache == null || !Status.STATUS_ALIVE.equals(this.cache.getStatus()) ? this.createCache() : this.manager.getCache(this.cacheId);
        return this.cache;
    }

    private Cache createCache() {
        int maxElementsInMemory = 20000;
        int timeToLiveSeconds = 600;
        int timeToIdleSeconds = 500;
        this.cacheId = UUID.randomUUID().toString();
        this.manager = CacheManager.create();
        this.cache = new Cache(this.cacheId, 20000, false, false, 600L, 500L);
        this.manager.addCache(this.cache);
        return this.cache;
    }
}

