/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.GenericCommand;
import sernet.verinice.interfaces.IAuthAwareCommand;
import sernet.verinice.interfaces.IAuthService;
import sernet.verinice.interfaces.ICachedCommand;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.ControlGroup;
import sernet.verinice.model.samt.SamtTopic;
import sernet.verinice.samt.service.FindSamtGroup;
import sernet.verinice.service.commands.crud.LoadReportElements;

public class FindISO27kSamtGroup
extends GenericCommand
implements IAuthAwareCommand,
ICachedCommand {
    private static final Logger log = LoggerFactory.getLogger(FindSamtGroup.class);
    private boolean resultInjectedFromCache = false;
    private transient IAuthService authService;
    private ControlGroup selfAssessmentGroup = null;
    private boolean hydrateParent;
    private int dbId;
    private static final String CONTROLGROUP_IS27KGROUP_PROPERTY = "controlgroup_is_NoIso_group";

    public FindISO27kSamtGroup() {
    }

    public FindISO27kSamtGroup(boolean hydrate, int rootId) {
        this.hydrateParent = hydrate;
        this.dbId = rootId;
    }

    public FindISO27kSamtGroup(boolean hydrate, String rootId) {
        this(hydrate, Integer.parseInt(rootId));
    }

    public void execute() {
        if (!this.resultInjectedFromCache) {
            LoadReportElements command = new LoadReportElements("controlgroup", Integer.valueOf(this.dbId));
            try {
                command = (LoadReportElements)this.getCommandService().executeCommand((ICommand)command);
            }
            catch (CommandException e) {
                log.error("Error while executing command");
            }
            List controlGroupList = null;
            if (command.getElements() != null && command.getElements().size() > 0) {
                controlGroupList = command.getElements();
            }
            if (controlGroupList == null) {
                controlGroupList = Collections.emptyList();
            }
            if (log.isDebugEnabled()) {
                log.debug("number of controlGroups " + FindISO27kSamtGroup.nullSaveSize(controlGroupList));
            }
            ArrayList<ControlGroup> resultList = new ArrayList<ControlGroup>();
            for (CnATreeElement elmt : controlGroupList) {
                ControlGroup controlGroup;
                if (!(elmt instanceof ControlGroup) || !this.isISO27kControlGroup(controlGroup = (ControlGroup)elmt) || !this.isSamtTopicCollection(controlGroup.getChildren())) continue;
                resultList.add(controlGroup);
            }
            if (resultList != null && !resultList.isEmpty()) {
                this.selfAssessmentGroup = this.determineRootControlgroup(resultList);
                if (this.selfAssessmentGroup != null) {
                    this.hydrate(this.selfAssessmentGroup);
                }
            }
        }
    }

    private ControlGroup determineRootControlgroup(List<ControlGroup> list) {
        ArrayList<ControlGroup> cList = new ArrayList<ControlGroup>(0);
        for (ControlGroup g : list) {
            if (!this.hasSamtTopicChildrenOnly(g) || !(g.getParent() instanceof ControlGroup)) continue;
            cList.add(g);
        }
        ControlGroup parent = null;
        boolean errorOccured = false;
        for (ControlGroup g : cList) {
            if (parent == null) {
                parent = (ControlGroup)g.getParent();
                continue;
            }
            if (parent.getUuid().equals(g.getParent().getUuid())) continue;
            errorOccured = true;
            break;
        }
        if (errorOccured) {
            return null;
        }
        return parent;
    }

    private boolean hasSamtTopicChildrenOnly(ControlGroup group) {
        boolean retVal = true;
        for (CnATreeElement elmt : group.getChildren()) {
            if (elmt instanceof SamtTopic) continue;
            retVal = false;
            break;
        }
        return retVal;
    }

    private static int nullSaveSize(List<CnATreeElement> controlGroupList) {
        int size = 0;
        if (controlGroupList != null) {
            size = controlGroupList.size();
        }
        return size;
    }

    private boolean isSamtTopicCollection(Collection<CnATreeElement> collection) {
        boolean isSamtTopicSet = true;
        for (CnATreeElement element : collection) {
            if (element != null && !(isSamtTopicSet = "controlgroup".equals(element.getTypeId()) ? this.isSamtTopicCollection(element.getChildren()) : "samt_topic".equals(element.getTypeId()))) break;
        }
        return isSamtTopicSet;
    }

    private void hydrate(ControlGroup selfAssessmentGroup) {
        selfAssessmentGroup.getTitle();
        if (this.hydrateParent) {
            selfAssessmentGroup.getParent().getTitle();
        }
    }

    private boolean isISO27kControlGroup(ControlGroup group) {
        String is27kGroup = group.getEntity().getValue(CONTROLGROUP_IS27KGROUP_PROPERTY);
        if (is27kGroup != null && is27kGroup.equals("0")) {
            is27kGroup = "true";
        }
        return Boolean.parseBoolean(is27kGroup);
    }

    public ControlGroup getSelfAssessmentGroup() {
        return this.selfAssessmentGroup;
    }

    public IAuthService getAuthService() {
        return this.authService;
    }

    public void setAuthService(IAuthService service) {
        this.authService = service;
    }

    public void setDBIDandHydrate(int dbId, boolean hydrate) {
        this.dbId = dbId;
        this.hydrateParent = hydrate;
    }

    public String getCacheID() {
        StringBuilder cacheID = new StringBuilder();
        cacheID.append(((Object)((Object)this)).getClass().getSimpleName());
        cacheID.append(String.valueOf(this.dbId));
        cacheID.append(String.valueOf(this.hydrateParent));
        return cacheID.toString();
    }

    public void injectCacheResult(Object result) {
        this.selfAssessmentGroup = (ControlGroup)result;
        this.resultInjectedFromCache = true;
        if (log.isDebugEnabled()) {
            log.debug("Result in " + ((Object)((Object)this)).getClass().getCanonicalName() + " injected from cache");
        }
    }

    public Object getCacheableResult() {
        return this.selfAssessmentGroup;
    }
}

