/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.service;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.interfaces.oda.IVeriniceOdaDriver;

public class Activator
implements BundleActivator {
    private final Logger log = LoggerFactory.getLogger(Activator.class);
    private static Activator plugin;
    private ServiceTracker commandServiceTracker;
    private ServiceTracker odaDriverTracker;

    public void start(BundleContext context) throws Exception {
        plugin = this;
        if (this.log.isInfoEnabled()) {
            Bundle bundle = context.getBundle();
            this.log.info("Starting bundle " + bundle.getSymbolicName() + " " + bundle.getVersion());
        }
        this.commandServiceTracker = new ServiceTracker(context, ICommandService.class.getName(), null);
        this.commandServiceTracker.open();
        this.odaDriverTracker = new ServiceTracker(context, IVeriniceOdaDriver.class.getName(), null);
        this.odaDriverTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.commandServiceTracker.close();
        this.odaDriverTracker.close();
    }

    public static Activator getDefault() {
        return plugin;
    }

    public ICommandService getCommandService() {
        return (ICommandService)this.commandServiceTracker.getService();
    }

    public IVeriniceOdaDriver getOdaDriver() {
        return (IVeriniceOdaDriver)this.odaDriverTracker.getService();
    }
}

