/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.oda.linktable.driver.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Normalizer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import org.springframework.remoting.RemoteConnectFailureException;
import sernet.verinice.oda.linktable.driver.impl.LinkTableResultSet;
import sernet.verinice.oda.linktable.driver.impl.Messages;
import sernet.verinice.oda.linktable.driver.impl.ResultSetMetaData;
import sernet.verinice.service.linktable.ColumnPathParser;
import sernet.verinice.service.linktable.ILinkTableConfiguration;
import sernet.verinice.service.linktable.LinkTableService;
import sernet.verinice.service.linktable.vlt.VeriniceLinkTable;
import sernet.verinice.service.linktable.vlt.VeriniceLinkTableIO;

public class Query
implements IQuery {
    private static final Logger log = Logger.getLogger(Query.class);
    public static final String ODA_DATA_SET_ID = "verinice.oda.linktable.driver.dataSet.id";
    private static final int DEFAULT_MAX_ROWS = 1000;
    private String vlt = null;
    private IResultSetMetaData resultSetMetaData;
    private Integer[] scopeIds;
    private int maxRows = 1000;
    private Map<String, List<List<String>>> queryCache;

    public Query(Integer[] rootElementIds) {
        this.scopeIds = rootElementIds;
    }

    public Query(Integer[] rootElementIds, Map<String, List<List<String>>> queryCache) {
        this(rootElementIds);
        this.queryCache = queryCache;
    }

    public void cancel() throws OdaException {
    }

    public void clearInParameters() throws OdaException {
    }

    public void close() throws OdaException {
        this.vlt = null;
    }

    public IResultSet executeQuery() throws OdaException {
        try {
            return new LinkTableResultSet(this.createMappedTable(), this.resultSetMetaData);
        }
        catch (RemoteConnectFailureException remoteConnectFailureException) {
            log.error((Object)Messages.query_connection_error_title, (Throwable)remoteConnectFailureException);
            throw new OdaException(Messages.query_connection_error_msg);
        }
    }

    private List<List<String>> createMappedTable() {
        if (this.queryCache != null) {
            return this.queryCache.computeIfAbsent(this.vlt, k -> this.createTable());
        }
        return this.createTable();
    }

    private List<List<String>> createTable() {
        LinkTableService linkTableService = new LinkTableService();
        List table = linkTableService.createTable(this.createLinkTableConfiguration());
        table.remove(0);
        table.forEach(row -> {
            int i = 0;
            while (i < row.size()) {
                String value = (String)row.get(i);
                if (value != null && !value.isEmpty()) {
                    row.set(i, Normalizer.normalize(value, Normalizer.Form.NFC));
                }
                ++i;
            }
        });
        return table;
    }

    public ILinkTableConfiguration createLinkTableConfiguration() {
        VeriniceLinkTable vltFile = VeriniceLinkTableIO.readContent((String)this.vlt);
        ILinkTableConfiguration linkTableConfiguration = VeriniceLinkTableIO.createLinkTableConfiguration((VeriniceLinkTable)vltFile);
        if (this.scopeIds == null || this.scopeIds.length == 0) {
            linkTableConfiguration.removeAllScopeIds();
        } else {
            Integer[] integerArray = this.scopeIds;
            int n = this.scopeIds.length;
            int n2 = 0;
            while (n2 < n) {
                Integer scopeId = integerArray[n2];
                linkTableConfiguration.addScopeId(scopeId);
                ++n2;
            }
        }
        return linkTableConfiguration;
    }

    public int findInParameter(String arg0) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public String getEffectiveQueryText() {
        return this.vlt;
    }

    public int getMaxRows() throws OdaException {
        return this.maxRows;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        return this.resultSetMetaData;
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        return null;
    }

    public SortSpec getSortSpec() throws OdaException {
        return null;
    }

    public QuerySpecification getSpecification() {
        return null;
    }

    public void prepare(String queryText) throws OdaException {
        this.vlt = queryText;
        List<String> columnList = Query.getColumnList(this.vlt);
        this.resultSetMetaData = new ResultSetMetaData(columnList.toArray(new String[columnList.size()]));
    }

    public static List<String> getColumnList(String queryText) {
        VeriniceLinkTable vltFile = VeriniceLinkTableIO.readContent((String)queryText);
        ILinkTableConfiguration linkTableConfiguration = VeriniceLinkTableIO.createLinkTableConfiguration((VeriniceLinkTable)vltFile);
        Set columnPaths = linkTableConfiguration.getColumnPaths();
        return columnPaths.stream().map(ColumnPathParser::extractAlias).collect(Collectors.toList());
    }

    public void setAppContext(Object arg0) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setBigDecimal(String arg0, BigDecimal arg1) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setBigDecimal(int arg0, BigDecimal arg1) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setBoolean(String arg0, boolean arg1) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setBoolean(int arg0, boolean arg1) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setDate(String arg0, Date arg1) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setDate(int arg0, Date arg1) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setDouble(String arg0, double arg1) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setDouble(int arg0, double arg1) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setInt(String arg0, int arg1) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setInt(int arg0, int arg1) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setMaxRows(int maxRows) throws OdaException {
        this.maxRows = maxRows;
    }

    public void setNull(String arg0) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setNull(int arg0) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setObject(String arg0, Object arg1) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setObject(int arg0, Object arg1) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setProperty(String arg0, String arg1) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setSortSpec(SortSpec arg0) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setSpecification(QuerySpecification arg0) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setString(String arg0, String arg1) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setString(int arg0, String arg1) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setTime(String arg0, Time arg1) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setTime(int arg0, Time arg1) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setTimestamp(String arg0, Timestamp arg1) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setTimestamp(int arg0, Timestamp arg1) throws OdaException {
        throw new UnsupportedOperationException();
    }
}

