/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.oda.linktable.driver.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class LinkTableResultSet
implements IResultSet {
    private static final Logger LOG = Logger.getLogger(LinkTableResultSet.class);
    private int maxRows = 0;
    private int currentRowId;
    private List<List<String>> linkTable;
    private IResultSetMetaData metaData;

    public LinkTableResultSet(List<List<String>> linkTable, IResultSetMetaData metaData) {
        this.linkTable = linkTable;
        this.metaData = metaData;
        if (linkTable != null) {
            this.maxRows = linkTable.size();
        }
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        return this.metaData;
    }

    public void setMaxRows(int maxRows) throws OdaException {
        this.maxRows = maxRows;
    }

    protected int getMaxRows() {
        return this.maxRows;
    }

    public boolean next() throws OdaException {
        if (this.currentRowId < this.maxRows) {
            ++this.currentRowId;
            return true;
        }
        return false;
    }

    public void close() throws OdaException {
        this.currentRowId = 0;
    }

    public int getRow() throws OdaException {
        return this.currentRowId;
    }

    public Object getObject(int index) throws OdaException {
        try {
            return this.linkTable.get(this.currentRowId - 1).get(index - 1);
        }
        catch (Exception e) {
            LOG.error((Object)("No value found for row: " + this.currentRowId + " and column: " + index), (Throwable)e);
            return null;
        }
    }

    public String getString(int index) throws OdaException {
        Object r = this.getObject(index);
        return r == null ? "null" : r.toString();
    }

    public String getString(String columnName) throws OdaException {
        return this.getString(this.findColumn(columnName));
    }

    public int getInt(int index) throws OdaException {
        return this.getRow();
    }

    public int getInt(String columnName) throws OdaException {
        return this.getInt(this.findColumn(columnName));
    }

    public double getDouble(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public double getDouble(String columnName) throws OdaException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(String columnName) throws OdaException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public Date getDate(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(String columnName) throws OdaException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(String columnName) throws OdaException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(String columnName) throws OdaException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public IBlob getBlob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IBlob getBlob(String columnName) throws OdaException {
        return this.getBlob(this.findColumn(columnName));
    }

    public IClob getClob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IClob getClob(String columnName) throws OdaException {
        return this.getClob(this.findColumn(columnName));
    }

    public boolean getBoolean(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(String columnName) throws OdaException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public Object getObject(String columnName) throws OdaException {
        return this.getObject(this.findColumn(columnName));
    }

    public boolean wasNull() throws OdaException {
        return false;
    }

    public int findColumn(String columnName) throws OdaException {
        throw new UnsupportedOperationException();
    }
}

