/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.oda.driver.preferences;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.PathEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import sernet.verinice.oda.driver.Activator;
import sernet.verinice.oda.driver.preferences.Messages;

public class ReportPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private String[][] logLvlValues = new String[][]{{Messages.getString("ReportLogLevel.0"), Level.INFO.toString()}, {Messages.getString("ReportLogLevel.1"), Level.WARNING.toString()}, {Messages.getString("ReportLogLevel.2"), Level.FINEST.toString()}, {Messages.getString("ReportLogLevel.3"), Level.SEVERE.toString()}, {Messages.getString("ReportLogLevel.4"), Level.ALL.toString()}};
    private DirectoryFieldEditor localTemplateEditor;
    private BooleanFieldEditor useSandboxEditor;

    public ReportPreferencePage() {
        super(1);
        this.setDescription(Messages.getString("ReportPreferencePage.0"));
    }

    public void init(IWorkbench arg0) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        BooleanFieldEditor reportLoggingEditor = new BooleanFieldEditor("report_logging_enabled", Messages.getString("ReportPreferencePage.1"), this.getFieldEditorParent());
        this.addField((FieldEditor)reportLoggingEditor);
        ComboFieldEditor logLvlFieldEditor = new ComboFieldEditor("report_logging_lvl", Messages.getString("ReportPreferencePage.2"), this.logLvlValues, this.getFieldEditorParent());
        this.addField((FieldEditor)logLvlFieldEditor);
        DirectoryFieldEditor logFileNameEditor = new DirectoryFieldEditor("report_log_file", Messages.getString("ReportPreferencePage.3"), this.getFieldEditorParent());
        this.addField((FieldEditor)logFileNameEditor);
        this.localTemplateEditor = new DirectoryFieldEditor("local_report_template_dir", Messages.getString("ReportPreferencePage.8"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.localTemplateEditor);
        BooleanFieldEditor useCacheEditor = new BooleanFieldEditor("report_use_cache", Messages.getString("ReportPreferencePage.7"), this.getFieldEditorParent());
        this.addField((FieldEditor)useCacheEditor);
        this.useSandboxEditor = new BooleanFieldEditor("report_use_sandbox", Messages.getString("ReportPreferencePage.9"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.useSandboxEditor);
        this.addField((FieldEditor)new PathEditor("report_classification_hints", Messages.getString("ReportPreferencePage.classifications"), null, this.getFieldEditorParent()){

            protected String getNewInputObject() {
                InputDialog inputDialog = new InputDialog(this.getShell(), Messages.getString("ReportPreferencePage.addclassifications"), Messages.getString("ReportPreferencePage.addclassifications"), "", null);
                inputDialog.open();
                return inputDialog.getValue();
            }

            protected String createList(String[] items) {
                return Arrays.stream(items).collect(Collectors.joining("///"));
            }

            protected String[] parseString(String hints) {
                return hints.split("///");
            }
        });
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getProperty().equals("field_editor_value")) {
            this.checkState();
        }
        if (event.getSource() == this.useSandboxEditor) {
            boolean deactivated;
            boolean bl = deactivated = (Boolean)event.getNewValue() == false;
            if (deactivated) {
                ReportPreferencePage.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)ReportPreferencePage.getDisplay().getActiveShell(), (String)Messages.getString("ReportPreferencePage.12"), (String)Messages.getString("ReportPreferencePage.13"));
                    }
                });
            }
        }
    }

    public boolean performOk() {
        Activator.getDefault().getIReportTemplateDirectoryService().setDirectory(this.localTemplateEditor.getStringValue());
        return super.performOk();
    }

    private static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    protected void checkState() {
        super.checkState();
        if (!this.isValid()) {
            return;
        }
    }
}

