/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.oda.driver.impl.filters;

import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import sernet.hui.common.connect.Entity;
import sernet.verinice.interfaces.oda.FilterChain;
import sernet.verinice.interfaces.oda.IChainableFilter;

public class SinglePropertyFilter
implements IChainableFilter {
    private static final Logger LOG = Logger.getLogger(SinglePropertyFilter.class);
    private static final long serialVersionUID = 4382916136268014218L;
    private String propertyKey;
    private String propertyValueRegex;
    private String entityType;

    public SinglePropertyFilter(String entityType, String propertyKey, String propertyValueRegex) {
        this.entityType = entityType;
        this.propertyKey = propertyKey;
        this.propertyValueRegex = propertyValueRegex;
    }

    public SinglePropertyFilter(String propertyKey, String propertyValueRegex) {
        this(null, propertyKey, propertyValueRegex);
    }

    public FilterChain asList() {
        return new FilterChain(new IChainableFilter[]{this}){

            public boolean matches(Entity entity) {
                return SinglePropertyFilter.this.matches(entity);
            }
        };
    }

    public boolean matches(Entity entity) {
        if (Optional.ofNullable(this.entityType).isPresent() && !entity.getEntityType().equals(this.entityType)) {
            return true;
        }
        Pattern pattern = Pattern.compile(this.propertyValueRegex);
        String value = entity.getPropertyValue(this.propertyKey);
        boolean find = pattern.matcher(value).find();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Filter for entityType '" + this.entityType + ", " + this.propertyKey + ", " + this.propertyValueRegex + "' returned " + find + " for element " + entity.getEntityType()));
        }
        return find;
    }
}

