/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.oda.driver.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import sernet.verinice.interfaces.oda.IImageProvider;
import sernet.verinice.oda.driver.impl.VeriniceURLConnection;

public class VeriniceURLStreamHandlerService
extends AbstractURLStreamHandlerService {
    private static final Logger LOG = Logger.getLogger(VeriniceURLStreamHandlerService.class);
    private Map<String, IImageProvider> imageStreams = new HashMap<String, IImageProvider>();

    public VeriniceURLStreamHandlerService() {
        final File f = new File("/usr/share/pixmaps/gnome-spider.png");
        this.setImageProvider("test", new IImageProvider(){

            public InputStream newInputStream(int width, int height) {
                try {
                    return Files.newInputStream(f.toPath(), new OpenOption[0]);
                }
                catch (IOException e) {
                    LOG.error((Object)"Could not register 'test' image");
                    throw new RuntimeException();
                }
            }
        });
    }

    void setImageProvider(String name, IImageProvider imageProvider) {
        this.imageStreams.put(name, imageProvider);
    }

    void remove(String name) {
        this.imageStreams.remove(name);
    }

    public URLConnection openConnection(URL u) throws IOException {
        int height;
        VeriniceURLConnection uc = new VeriniceURLConnection(u);
        String imageId = u.getAuthority();
        IImageProvider provider = this.imageStreams.get(imageId);
        String queryPart = u.getQuery();
        HashMap<String, String> parms = new HashMap<String, String>();
        if (queryPart != null) {
            String[] split = queryPart.split("=|&");
            int i = 0;
            while (i + 1 < split.length) {
                parms.put(split[i], split[i + 1]);
                i += 2;
            }
        }
        int width = parms.containsKey("width") ? Integer.parseInt((String)parms.get("width")) : 200;
        int n = height = parms.containsKey("height") ? Integer.parseInt((String)parms.get("height")) : 60;
        if (provider == null) {
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g2d = (Graphics2D)image.getGraphics();
            g2d.setBackground(Color.WHITE);
            g2d.setColor(Color.BLACK);
            g2d.clearRect(0, 0, width, height);
            g2d.drawString(String.format("Image '%s' not available!", imageId), 5, 30);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "jpeg", bos);
            final byte[] imageData = bos.toByteArray();
            provider = new IImageProvider(){

                public InputStream newInputStream(int width, int height) {
                    return new ByteArrayInputStream(imageData);
                }
            };
        }
        uc.setBounds(width, height);
        uc.setImageProvider(provider);
        return uc;
    }
}

