/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.oda.driver.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.ComponentContext;
import sernet.verinice.interfaces.oda.IImageProvider;
import sernet.verinice.interfaces.oda.IVeriniceOdaDriver;
import sernet.verinice.oda.driver.Activator;
import sernet.verinice.oda.driver.impl.VeriniceURLStreamHandlerService;

public class VeriniceOdaDriver
implements IVeriniceOdaDriver {
    private VeriniceURLStreamHandlerService urlStreamHandlerFactory;
    private Map<String, Object> vars = new HashMap<String, Object>();
    private static Object instance;
    private static final String REPORT_LOGFILE = "verinice-reports.log";

    public VeriniceOdaDriver() {
        if (instance != null) {
            throw new IllegalStateException();
        }
    }

    protected void activate(ComponentContext ctx) {
        this.urlStreamHandlerFactory = Activator.getDefault().getURLStreamHandlerService();
    }

    public void setImageProvider(String name, IImageProvider imageProvider) {
        this.urlStreamHandlerFactory.setImageProvider(name, imageProvider);
    }

    public void removeImageProvider(String name) {
        this.urlStreamHandlerFactory.remove(name);
    }

    public void setScriptVariables(Map<String, Object> vars) {
        this.vars = vars;
    }

    public Map<String, Object> getScriptVariables() {
        return this.vars;
    }

    public boolean getReportLoggingState() {
        return Activator.getDefault().getPreferenceStore().getBoolean("report_logging_enabled");
    }

    public String getLogLvl() {
        return Activator.getDefault().getPreferenceStore().getString("report_logging_lvl");
    }

    public String getLogFile() {
        String path = Activator.getDefault().getPreferenceStore().getString("report_log_file");
        if (path != null && !path.endsWith(String.valueOf(File.separatorChar))) {
            path = String.valueOf(path) + File.separatorChar;
        }
        return String.valueOf(path) + REPORT_LOGFILE;
    }

    public String getLocalReportLocation() {
        return Activator.getDefault().getPreferenceStore().getString("local_report_template_dir");
    }

    public boolean isSandboxEnabled() {
        String pref = Activator.getDefault().getPreferenceStore().getString("report_use_sandbox");
        return Boolean.parseBoolean(pref);
    }
}

