/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.oda.driver.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import sernet.verinice.oda.driver.impl.Driver;

public class ResultSetMetaData
implements IResultSetMetaData {
    private int columnCount;
    private int rowCount;
    private final Accessor accessor;
    private Object result;
    private String[] columns;

    ResultSetMetaData(Object result, String[] columns) {
        this.result = result;
        this.columns = columns != null ? (String[])columns.clone() : null;
        Class<? extends Accessor> accessorClass = this.initValues(result, columns);
        this.accessor = accessorClass.equals(MultiDimensionalArrayAccessor.class) ? new MultiDimensionalArrayAccessor() : (accessorClass.equals(OneDimensionalArrayAccessor.class) ? new OneDimensionalArrayAccessor() : (accessorClass.equals(MultiDimensionalCollectionAccessor.class) ? new MultiDimensionalCollectionAccessor() : (accessorClass.equals(OneDimensionalCollectionAccessor.class) ? new OneDimensionalCollectionAccessor() : new SingleValueAccessor())));
    }

    private Class<? extends Accessor> initValues(Object result, String[] columns) {
        Class clazz = null;
        Class<?> rowClass = result.getClass();
        if (rowClass.isArray() && rowClass.getComponentType() != Byte.TYPE) {
            Class<?> columnClass;
            Object firstElement = Array.getLength(result) > 0 ? Array.get(result, 0) : null;
            Class<?> clazz2 = columnClass = firstElement != null ? firstElement.getClass() : null;
            if (columnClass != null && columnClass.isArray()) {
                this.columnCount = columns != null ? columns.length : Array.getLength(firstElement);
                this.rowCount = Array.getLength(result);
                clazz = MultiDimensionalArrayAccessor.class;
            } else {
                this.columnCount = columns != null ? columns.length : 1;
                this.rowCount = Array.getLength(result);
                clazz = OneDimensionalArrayAccessor.class;
            }
        } else if (Collection.class.isAssignableFrom(rowClass)) {
            Class<?> columnClass;
            Object[] arr = ((Collection)result).toArray();
            Object firstElement = arr.length > 0 ? arr[0] : null;
            Class<?> clazz3 = columnClass = firstElement != null ? firstElement.getClass() : null;
            if (columnClass != null && Collection.class.isAssignableFrom(columnClass)) {
                this.columnCount = columns != null ? columns.length : ((Collection)firstElement).size();
                this.rowCount = ((Collection)result).size();
                clazz = MultiDimensionalCollectionAccessor.class;
            } else {
                this.columnCount = columns != null ? columns.length : 1;
                this.rowCount = ((Collection)result).size();
                clazz = OneDimensionalCollectionAccessor.class;
            }
        } else {
            this.columnCount = columns != null ? columns.length : 1;
            this.rowCount = 1;
            clazz = SingleValueAccessor.class;
        }
        if (this.rowCount == 0) {
            this.rowCount = -1;
        }
        return clazz;
    }

    Object getValue(int row, int column) {
        try {
            return this.accessor.get(this.result, row - 1, column - 1);
        }
        catch (ArrayIndexOutOfBoundsException aiiobe) {
            return null;
        }
    }

    public int getColumnCount() throws OdaException {
        return this.columnCount;
    }

    public String getColumnName(int index) throws OdaException {
        if (this.columns != null) {
            return this.columns[index - 1];
        }
        return "Column" + index;
    }

    int getRowCount() {
        return this.rowCount;
    }

    public String getColumnLabel(int index) throws OdaException {
        return this.getColumnName(index);
    }

    public int getColumnType(int index) throws OdaException {
        return 2000;
    }

    public String getColumnTypeName(int index) throws OdaException {
        int nativeTypeCode = this.getColumnType(index);
        return Driver.getNativeDataTypeName(nativeTypeCode, "verinice.oda.driver.dataSet.id");
    }

    public int getColumnDisplayLength(int index) throws OdaException {
        return 8;
    }

    public int getPrecision(int index) throws OdaException {
        return -1;
    }

    public int getScale(int index) throws OdaException {
        return -1;
    }

    public int isNullable(int index) throws OdaException {
        return 2;
    }

    static interface Accessor {
        public Object get(Object var1, int var2, int var3);
    }

    static class MultiDimensionalArrayAccessor
    implements Accessor {
        MultiDimensionalArrayAccessor() {
        }

        @Override
        public Object get(Object result, int row, int column) {
            return Array.get(Array.get(result, row), column);
        }
    }

    static class MultiDimensionalCollectionAccessor
    implements Accessor {
        MultiDimensionalCollectionAccessor() {
        }

        @Override
        public Object get(Object result, int row, int column) {
            return ((Collection)((Collection)result).toArray()[row]).toArray()[column];
        }
    }

    static class OneDimensionalArrayAccessor
    implements Accessor {
        OneDimensionalArrayAccessor() {
        }

        @Override
        public Object get(Object result, int row, int column) {
            return Array.get(result, row);
        }
    }

    static class OneDimensionalCollectionAccessor
    implements Accessor {
        OneDimensionalCollectionAccessor() {
        }

        @Override
        public Object get(Object result, int row, int column) {
            return ((Collection)result).toArray()[row];
        }
    }

    static class SingleValueAccessor
    implements Accessor {
        SingleValueAccessor() {
        }

        @Override
        public Object get(Object result, int row, int column) {
            return result;
        }
    }
}

